

/********************************************************************\

  Name:         Utilities.cc

  Created by:   Sebastian Commichau, July 2008
                commichau@phys.ethz.ch

  Content:      Provides numerous utilities

\********************************************************************/
 

#include "Utilities.h"


// Parse user input 
void ParseInput(char* Pc, int* NParam, char Param[][MAX_COM_SIZE])
{
  int i;
  *NParam = 0;

  for (i = 0; i<10; i++)
    Param[i][MAX_COM_SIZE] = 0;

  while (*Pc == ' ') // Ignore leading blanks
    Pc++;
  
  do {
    if (*Pc == '"') {
      Pc++;
      for (i = 0; *Pc && *Pc != '"'; i++)
	Param[*NParam][i] = *Pc++;
      if (*Pc)
	Pc++;
    } else if (*Pc == '\'') {
      Pc++;
      for (i = 0; *Pc && *Pc != '\''; i++)
	Param[*NParam][i] = *Pc++;
      if (*Pc)
	Pc++;
    } else if (*Pc == '`') {
      Pc++;
      for (i = 0; *Pc && *Pc != '`'; i++)
	Param[*NParam][i] = *Pc++;
      if (*Pc)
	Pc++;
    } else
      for (i = 0; *Pc && *Pc != ' '; i++)
	Param[*NParam][i] = *Pc++;
    Param[*NParam][i] = 0;
    while (*Pc == ' ' || *Pc == '\r' || *Pc == '\n')
      Pc++;
    (*NParam)++;
  } while (*Pc);

}


// Check if two strings match
int Match(char *str, char *cmd)
{
   int i;

   if(str[0] == '\r' || str[0] == '\n')
     return 0;

   for(i = 0; i < (int) strlen(str); i++) 
     {
       if(toupper(str[i]) != toupper(cmd[i]) && str[i] != '\r' && str[i] != '\n')
         return 0;
     }

   return 1;
}


// Remove newline from string
char* Chop(char str[]) {

  char *ptr;

  if ((ptr = strchr(str, '\n')) != NULL)
    *ptr = '\0';

  return str;

}


int MakeDir(char *Dir, char *RunDate) {

   char str[MAX_COM_SIZE];

   sprintf(str,"%s/%s",Dir,RunDate);

   struct stat buf;

   if (stat(str, &buf)) 
     return mkdir(str, 0711);
   
   return 0;
}



void GetUTCSecondsOfDay(double* t) {
  
  struct tm * timeinfo;
  time_t rawtime;
  
  struct timezone tz;
  struct timeval actual_time;   // Actual time 
  
  gettimeofday(&actual_time, &tz);
  
  time(&rawtime);
  
  timeinfo = gmtime(&rawtime);      // Get UTC (or GMT timezone).
  
  *t = (timeinfo->tm_hour*3600 + timeinfo->tm_min*60 + timeinfo->tm_sec) + actual_time.tv_usec/1000000.;
  
}


void GetLocalSecondsOfDay(double* t) {
  
  struct tm * timeinfo;
  time_t rawtime;
  
  struct timezone tz;
  struct timeval actual_time;   // Actual time 
  
  gettimeofday(&actual_time, &tz);
  
  time(&rawtime);
  
  timeinfo = localtime(&rawtime); // Get local time
  
  *t = (timeinfo->tm_hour*3600 + timeinfo->tm_min*60 + timeinfo->tm_sec) + actual_time.tv_usec/1000000.;
  
}


void GetLocalDay(int* t) {
  
  struct tm * timeinfo;
  time_t rawtime;
  
  time(&rawtime);
  
  timeinfo = localtime(&rawtime); // Get local time
  
  *t = (timeinfo->tm_yday);
  
}


double GetDiffTime(time_t* StartT) {

  time_t ActualT;

  time (&ActualT);

  return difftime (ActualT,*StartT);

}


long int GetMicroSeconds() {

  struct tm * timeinfo;
  time_t rawtime;
  
  struct timezone tz;
  struct timeval actual_time;   // Actual time
  
  gettimeofday(&actual_time, &tz);
  
  time(&rawtime);
  
  timeinfo = gmtime(&rawtime);  // Get UTC (or GMT timezone).
  
  return (timeinfo->tm_hour*3600 + timeinfo->tm_min*60 + timeinfo->tm_sec)*1000000 + actual_time.tv_usec;

}


/* Prints the binary representation of a 1 byte-integer to stdout */
void PrintByteBin(unsigned char i) {

  for (int k=7;k>=0;k--)
    if ((i & (1 << k)) !=0) {
        if ((k)%8)
        printf("1");
        else
        printf("1 ");
    }
    else {
        if ((k)%8)
        printf("0");
        else
        printf("0 ");
    }
  printf("\n");
}


/* Prints the binary representation of a 1-byte integer to str */
void sPrintByteBin(unsigned char i, char* str) {

  bzero(str,sizeof(str));

  for (int k=7;k>=0;k--)
    if ((i & (1 << k)) !=0) {
      if ((k)%8)
        strcat(str,"1");
      else
        strcat(str,"1 ");
    }
    else {
      if ((k)%8)
	strcat(str,"0");
      else
	strcat(str,"0 ");
    }
}


/* Prints the binary representation of a 2-byte integer to stdout */
void PrintWordBin(unsigned short i) {

  for (int k=15;k>=0;k--)
    if ((i & (1 << k)) !=0) {
        if ((k)%8)
        printf("1");
        else
        printf("1 ");
    }
    else {
        if ((k)%8)
        printf("0");
        else
        printf("0 ");
    }
  printf("\n");

}


/* Prints the binary representation of a 2-byte integer to str */
void sPrintWordBin(unsigned short i, char* str) {

  bzero(str,sizeof(str));

  for (int k=15;k>=0;k--)
    if ((i & (1 << k)) !=0) {
      if ((k)%8)
	strcat(str,"1");
      else
	strcat(str,"1 ");
    }
    else {
      if ((k)%8)
	strcat(str,"0");
      else
	strcat(str,"0 ");
    }
}


/* 
  Converts a hexadecimal string to integer - returns
 -1    - Conversion was abnormally terminated by
         occurrence of an illegal character
  0    - Conversion was successful 
  1    - String is empty
  2    - String has more than 2 characters
*/
int sPrintHex2Dec(const char* xs, unsigned int* result) {

  size_t szlen = strlen(xs);
  int xv, fact;
  
  if (szlen>0) {
    // Converting more than 32 bit hexadecimal value?
    if (szlen>4) return 4; 
    
    // Begin conversion here
    *result = 0;
    fact = 1;
    
    // Run until no more character to convert
    for (int i=szlen-1; i>=0; i--) {
      if (isxdigit(*(xs+i))) {
	if (*(xs+i)>=97) {
	  xv = ( *(xs+i) - 97) + 10;
	}
	else if ( *(xs+i) >= 65) {
	  xv = (*(xs+i) - 65) + 10;
	}
	else {
	    xv = *(xs+i) - 48;
	}
	*result += (xv * fact);
	fact *= 16;
      }
      else {
	// Conversion was abnormally terminated
	// by non hexadecimal digit, hence
	// returning only the converted with
	// an error value 0 (illegal hex character)
	return -1;
      }
    }
    return 0;
  }

  // Nothing to convert - string is empty
  return 1;
}


/* An integer is interpreted as binary number and converted to an integer */
int Bin2Dec(int bin)
{
  int power = 0;
  int decimal = 0;
  int num;
  
  while (bin > 0) {

    num = bin % 10;
    decimal = decimal + num * (int) pow(num * 2, power++);
    bin = bin / 10;
  }
  
  return decimal;
}


/* 
  Converts a binary string to integer - returns
 -1    - Conversion was abnormally terminated by
         occurrence of an illegal character
  0    - Conversion was successful 
  1    - String is empty
  8    - String has more than 8 characters
*/
int sPrintBin2Dec(const char* bs, unsigned int* result) {

  size_t szlen = strlen(bs);

  *result = 0;

  int p=0;

  if (szlen>0) {

    // Converting more than 32 bit value?
    if (szlen>32) return 32; 

    // Begin conversion here    
    for (int i=szlen-1; i>=0; i--) {

      if (*(bs+i)=='1' || *(bs+i)=='0') {

	if (*(bs+i)=='1') 
	  *result += (int)pow(2.,(double)p);
	
	p++;
      }
      else return -1;
    }
    return 0;

  }
  // Nothing to convert - string is empty
  return 1;   
}



/* Converts a binary string to a decimal number, returns decimal value */
int Bin2Dec(const char *bs) {

  int b, /*m,*/ n;
  int len, sum = 0;
  
  len = strlen(bs) - 1;
  
  for (int k = 0; k <= len; k++) {
        
    b = 1;

    n = (bs[k] - '0'); // Char to numeric value
    
    if ((n > 1) || (n < 0))
      return 0;
    
    
    b = b << (len-k);
    
    //for (b = 1, m = len; m > k; m--) 
    //b *= 2; // 1 2 4 8 16 32 64 ... place-values, reversed here
        
    // Sum it up
    sum = sum + n * b;
    
    //printf("%d*%d + ",n,b);
  }
  return sum;
}


int IsNoDigit(const char* str) {

  size_t szlen = strlen(str); 

  if (szlen>0) {

    for (int i=szlen-1; i>=0; i--) {
      if (isalpha((int)*(str+i)))
	return 0;
    }
    // Okay, no alphabetic character found
    return 1;
  }
  // String is empty
  return -1;
}


void SignalHandler(int Signal) {
  return;          
}
