#ifndef MARS_MHMatrix
#define MARS_MHMatrix

#ifndef ROOT_TMatrix
#include <TMatrix.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class TArrayI;
class MDataArray;

class MHMatrix : public MH
{
protected:
    Int_t   fNumRow;    //! Number of dimensions of histogram
    TMatrix fM;         // Matrix to be filled

    TMatrix fM2;        //!

    MDataArray *fData;  // List of data members (columns)

    enum {
        kIsOwner = BIT(14)
    };

    void AddRow();

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

    void StreamPrimitive(ofstream &out) const;

public:
    MHMatrix(const char *name=NULL, const char *title=NULL);
    MHMatrix(MDataArray *mat, const char *name=NULL, const char *title=NULL);
    ~MHMatrix();

    void AddColumn(const char *name);
    void AddColumns(MDataArray *mat);

    MDataArray *GetColumns() { return fData; }

    const TMatrix &GetM() const { return fM; }

    //void Draw(Option_t *opt=NULL);
    //TObject *DrawClone(Option_t *opt=NULL) const;

    void Print(Option_t *) const;

    const TMatrix *InvertPosDef();

    Double_t CalcDist(const TMatrix &m, const TVector &v, Int_t num = 25) const;
    Double_t CalcDist(const TVector &v, Int_t num = 25);

    void SetIOwner(Bool_t b=kTRUE) { b ? SetBit(kIsOwner) : ResetBit(kIsOwner); }

    void Reassign();

    const TArrayI GetIndexOfSortedColumn(Int_t ncol=0, Bool_t desc=kTRUE) const;
    void SortMatrixByColumn(Int_t ncol=0, Bool_t desc=kTRUE);

    ClassDef(MHMatrix, 1) // Multidimensional Matrix to store events
};

#endif
