#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <errno.h>
#include <exception>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define STATUS_SIZE 1000					// Bytes for status service string

using namespace std;

// Declaration of item for history buffer (see DColl.cc)
struct EvidenceHistoryItem {
  int Seconds;
  double Value;
} __attribute__((__packed__));

// Class declation of Evidence server
class EvidenceServer: public DimServer {

  private:
	struct ConfigItem {
	  char *Name;
	  char *Value;
	  int Time;
	} *ConfigList;
	unsigned int ConfigNum;

    DimService *Status;

    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();
	
	enum StateType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void State(StateType, const char *, ...);
	char* GetConfig(const char *, const char * = NULL);
	static char* ToString(DimInfo *);

    static bool ExitRequest;
};

#endif
