	#include <sys/types.h>
        #include <sys/stat.h>
	#include <sys/time.h>
        #include <fcntl.h>
        #include <termios.h>
        #include <stdio.h>
	#include <time.h>
	#include <stdlib.h>
	#include <string.h>
	#include <unistd.h>
	#include <sys/select.h>

	 #define bzero(b,len) (memset((b), '\0' ,(len)), (void) 0)
	
	
    	/*
	  Included for Evidence server
	*/	
	#define SERVER_NAME "ARDUINO"	// Name to use in DIM
    	#include "Evidence.h"
    	#define NUM_VAL 10
	
        /* baudrate settings are defined in <asm/termbits.h>, which is
        included by <termios.h> */
        #define BAUDRATE B9600            
        /* change this definition for the correct port */
        #define MODEMDEVICE "/dev/myArduino"
        #define _POSIX_SOURCE 1 /* POSIX compliant source */

        #define FALSE 0
        #define TRUE 1

	 #define myPath "/ct3data/SlowData/" //   will be used later on
	//#define myPath "" // for testing purposes
	

	FILE * openOutfile(char *);
	static int poll_stdin_time(int);

        volatile int STOP=FALSE; 

	int main(int argc, char *argv[])
        {
          int fd, res;
          struct termios oldtio,newtio;
          char buf[255];

    	/*
	  Start Evidence server and create services
	*/
	EvidenceServer Srv(SERVER_NAME);

    	float Val[NUM_VAL];
	char Name[100];
	DimService *Service[NUM_VAL];

	for (int i=0; i<NUM_VAL; i++) {
	  Val[i] = -99;
	  snprintf(Name, sizeof(Name), SERVER_NAME"/VAL%.2d", i);
    	  Service[i] = new DimService (Name, Val[i]);
	}

        /* 
          Open modem device for reading and writing and not as controlling tty
          because we don't want to get killed if linenoise sends CTRL-C.
        */
         fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY ); 
         if (fd <0) {perror(MODEMDEVICE); exit(-1); }
        
         tcgetattr(fd,&oldtio); /* save current serial port settings */
         bzero(&newtio, sizeof(newtio)); /* clear struct for new port settings */
        
        /* 
          BAUDRATE: Set bps rate. You could also use cfsetispeed and cfsetospeed.
          CRTSCTS : output hardware flow control (only used if the cable has
                    all necessary lines. See sect. 7 of Serial-HOWTO)
          CS8     : 8n1 (8bit,no parity,1 stopbit)
          CLOCAL  : local connection, no modem contol
          CREAD   : enable receiving characters
        */
         newtio.c_cflag = BAUDRATE |  CS8 | CLOCAL | CREAD;

        //  CRTSCTS |  maybe not needed //DN 090907

        /*
          IGNPAR  : ignore bytes with parity errors
          ICRNL   : map CR to NL (otherwise a CR input on the other computer
                    will not terminate input)
          otherwise make device raw (no other input processing)
        */
         newtio.c_iflag = IGNPAR ;
        
	// | ICRNL // i guess this is not needed here. DN 090907
 
        /*
         Raw output.
        */
         newtio.c_oflag = 0;
         
        /*
          ICANON  : enable canonical input
          disable all echo functionality, and don't send signals to calling program
        */
         newtio.c_lflag = ICANON;
         
        /* 
          initialize all control characters 
          default values can be found in /usr/include/termios.h, and are given
          in the comments, but we don't need them here
        */
         newtio.c_cc[VINTR]    = 0;     /* Ctrl-c */ 
         newtio.c_cc[VQUIT]    = 0;     /* Ctrl-\ */
         newtio.c_cc[VERASE]   = 0;     /* del */
         newtio.c_cc[VKILL]    = 0;     /* @ */
         newtio.c_cc[VEOF]     = 4;     /* Ctrl-d */
         newtio.c_cc[VTIME]    = 0;     /* inter-character timer unused */
         newtio.c_cc[VMIN]     = 1;     /* blocking read until 1 character arrives */
         newtio.c_cc[VSWTC]    = 0;     /* '\0' */
         newtio.c_cc[VSTART]   = 0;     /* Ctrl-q */ 
         newtio.c_cc[VSTOP]    = 0;     /* Ctrl-s */
         newtio.c_cc[VSUSP]    = 0;     /* Ctrl-z */
         newtio.c_cc[VEOL]     = 0;     /* '\0' */
         newtio.c_cc[VREPRINT] = 0;     /* Ctrl-r */
         newtio.c_cc[VDISCARD] = 0;     /* Ctrl-u */
         newtio.c_cc[VWERASE]  = 0;     /* Ctrl-w */
         newtio.c_cc[VLNEXT]   = 0;     /* Ctrl-v */
         newtio.c_cc[VEOL2]    = 0;     /* '\0' */
        
        /* 
          now clean the modem line and activate the settings for the port
        */
         tcflush(fd, TCIFLUSH);
         tcsetattr(fd,TCSANOW,&newtio);
        
        /*
          terminal settings done, now handle input
          In this example, inputting a 'z' at the beginning of a line will 
          exit the program.
        */

	FILE *outfile;
	

	char outstring[400];
	//char c;
   	char Temp[200], *Token;
	
         while (STOP==FALSE) {     /* loop until we have a terminating condition */
         /* read blocks program execution until a line terminating character is 
            input, even if more than 255 chars are input. If the number
            of characters read is smaller than the number of chars available,
            subsequent reads will return the remaining chars. res will be set
            to the actual number of characters actually read */
            res = read(fd,buf,255); 
            buf[res]=0;             /* set end of string, so we can printf */
	
	    
		if (strncmp (buf,"[Temp,",6) != 0) continue;

		strncpy(Temp, buf, sizeof(Temp));
		Token = strtok(Temp, ", ");  
		for (int i=0; i<NUM_VAL; i++) {
		  Token = strtok(NULL, ", ");
		  if (Token != NULL) Val[i] = atof(Token);
    	    	  Service[i]->updateService();
    	    	}

		outfile = openOutfile(myPath);
		if (outfile == NULL) {return -1;}	
		
		time_t rawtime;
	  	struct tm * timeinfo;

		time ( &rawtime );
		timeinfo = localtime ( &rawtime );
	    
		struct timeval timeofday;
		gettimeofday(&timeofday, NULL);


		sprintf(outstring, "DALLAS Sensorvalues %04d %02d %02d %02d %02d %02d %03d %d %s",
					(*timeinfo).tm_year+1900,
					(*timeinfo).tm_mon+1,
					(*timeinfo).tm_mday,
					(*timeinfo).tm_hour,
					(*timeinfo).tm_min,
					(*timeinfo).tm_sec,
					(int) timeofday.tv_usec/1000,
					(int)rawtime,
					buf);
            
		printf("%s", outstring);

            fprintf(outfile, "%s", outstring);
	    fflush(outfile);		
	fclose(outfile);
        
	if (poll_stdin_time(atoi(Srv.GetConfig("Period", "10")))==1) {
		STOP=TRUE;
	}


	if (EvidenceServer::ExitRequest == true) STOP=TRUE;
	} //end while(STOP==FALSE)


        
	/* restore the old port settings */
        tcsetattr(fd,TCSANOW,&oldtio);

    	/*
	  Delete Evidence services
	*/
	for (int i=0; i<NUM_VAL; i++) {
    	  delete Service[i];
	}

return 0;
} //end main();

// OPens or Creates an Outfile named
// "CLIM_YYYYMMDD.slow"
// this file should contain all enviromentals from noon to noon.
// The File is created if it doesn't exist.
// all data is appended, nothing will be deleted or overwritten.
  
FILE * openOutfile(char *path)
{
	FILE *outfile;
	
	time_t rawtime;
  	struct tm * timeinfo;

	time ( &rawtime );
	timeinfo = gmtime ( &rawtime );
	
	// check what day it is today :-)
	if ((*timeinfo).tm_hour >12){ //then it is already tommorow
	rawtime += 86400;
	timeinfo = gmtime ( &rawtime );
	}	
	//generate filename
	char *outfilename;
	outfilename =(char*) calloc( strlen(path)+25 , sizeof(char));
	if (outfilename ==NULL)
	{
		perror("could not allocate space for outputfilename");
		return NULL;
	}
	sprintf(outfilename,"%sCLIM_%04d%02d%02d.slow",
			path, // from user
			(*timeinfo).tm_year+1900,
			(*timeinfo).tm_mon+1, 
			(*timeinfo).tm_mday ); 
	
	// there is no need to check if file is already existing.
	// if not fopen(name,"a") will create it.
	// if it exists
	// it will only be opened for appnendign
	outfile = fopen(outfilename,"a"); 
	
	if (outfile==NULL){
		perror("could not open outputfile");
		return NULL;}
	
	return outfile;	
}

static int poll_stdin_time(int sekunden) {
	struct timeval timeout;
	fd_set read_fds;
	int c;
	int stdin_status;

	FD_ZERO(&read_fds);
	FD_SET(STDIN_FILENO, &read_fds);
	timeout.tv_sec = sekunden;
	timeout.tv_usec = 0;
	stdin_status = select(STDIN_FILENO+1, &read_fds, NULL, NULL, &timeout);
	if (stdin_status == 1 ) {
		c=getchar(); 	
		fflush(stdin);
		if (c=='q') {
			return 1;
		}
	} else if (stdin_status ==0) {
		return 0;
	} else {
		perror("select()");
	}
	


		return -1;


}
