#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

#root=/opt/root_svn/bin/thisroot.sh
#source $root
#factpath=/home/fact/FACT++.in-run-fad-loss

#anapath=/loc_data/analysis

if [ "$1" = "" ]
then 
   # get date (before 18h there is no new data to be processed)
   datepath=`date --date="-18HOUR" +%Y/%m/%d`
else
   datepath=$1
fi
printprocesslog "INFO processing "$datepath
#echo "INFO processing "$datepath
night=`echo $datepath | sed -e 's/\///g'`

sources=( 1 2 5 7 )
numganymeds=0

for source in ${sources[@]}
do 
   # doing first 5min datasets, i.e. one image file per dataset
   min=5
   # getting all image files for this source and night
   printprocesslog "INFO get file list for source "$source
   files=( `find /loc_data/analysis/$source/star/$datepath -type f -name '*_I.root' 2>/dev/null | sort` )
   if [ ${#files[@]} -eq 0 ]
   then
      printprocesslog "INFO no image files available for source "$source" on "$datepath
      continue
   fi
   # write data set file
   dspath=$anapath/$source/datasets`printf %03d $min`min/$datepath
   makedir $dspath
   for (( i=1 ; i<=${#files[@]} ; i++ ))
   do 
      dsfile=$dspath/dataset$i.txt
      printprocesslog "INFO writing dataset file "$dsfile
      # write dataset only if merpp-log is available to make sure that star-file is complete
      merpplog=`echo ${files[$i-1]} | sed -e 's/_I.root/-merpp.log/'`
      stillrunning=`find $merpplog -mmin -1 2>/dev/null`
      if [ -e $merpplog ] && [ "$stillrunning" == "" ]
      then 
         echo `dirname ${files[$i-1]}`" "`basename ${files[$i-1]}` > $dsfile
      else
         echo "merpp still running - wait with file "${files[$i-1]}
         continue
      fi
      # process only if ganymedlogfiles is not yet there
      logfile=`echo $dsfile | sed -e 's/datasets/ganymed/' -e 's/dataset//' -e 's/[.]txt/-ganymed[.]log/'`
      if ! ls $logfile >/dev/null 2>&1
      then
         echo $logfile" "${files[$i-1]}
         `dirname $0`/RunGanymed.sh $source $dsfile
         numganymeds=`echo " $numganymeds + 1 " | bc -l`
      fi
   done 
   
   # get list of 5min-dataset-files as starting point
   printprocesslog "INFO get list of dataset files for "$min"min"
   files=( `find $dspath -type f -name 'dataset*.txt' | sort` )
   minold=5
   # loop over data set files
   # copy always 2 in one new file for double observation time
   while [ ${#files[@]} -gt 1 ]
   do
      # get double observation time and path for datasets
      min=`echo " $minold + $minold " | bc -l `
      dspathold=$dspath
      dspath=$anapath"/"$source"/datasets"`printf %03d $min`"min/"$datepath
      makedir $dspath
      # loop over already existing data set files
      for (( i=0 ; i<=${#files[@]} ; i++ ))
      do 
         # number of 1st and 2nd old dataset file
         num1=`echo " $i + $i + 1" | bc -l `
         num2=`echo " $i + $i + 2 " | bc -l `
         # number of new dataset file
         dsnum=`echo " $i + 1 " | bc -l `
         # continue only if 2 dataset files are left
         if ! [ ${files[$num1]} ]
         then 
            break
         fi
         ds1=$dspathold"/dataset"$num1".txt"
         ds2=$dspathold"/dataset"$num2".txt"
         dsfile=$dspath"/dataset"$dsnum".txt"
         if ! [ -e $ds1 ] || ! [ -e $ds2 ] 
         then
            echo $ds1" or "$ds2" is still missing -> continue."
            continue
         fi
         # copy two old into one new dataset file
         printprocesslog "INFO writing dataset "$dsfile
         cat $ds1 > $dsfile
         cat $ds2 >> $dsfile
         # process only if ganymedlogfiles is not yet there
         logfile=`echo $dsfile | sed -e 's/datasets/ganymed/' -e 's/dataset//' -e 's/[.]txt/-ganymed[.]log/'`
         if ! ls $logfile  >/dev/null 2>&1
         then
            echo $logfile
            `dirname $0`/RunGanymed.sh $source $dsfile
             numganymeds=`echo " $numganymeds + 1 " | bc -l`
         fi
      done
      # get list of new dataset files
      printprocesslog "INFO get list of dataset files for "$min"min"
      files=( `find $dspath -type f -name 'dataset*.txt' | sort` )
      minold=$min
   done
   if [ $numganymeds -gt 0 ]
   then 
       if ! ps aux | grep Step2b | grep -v grep >/dev/null 2>&1
       then 
         `dirname $0`/Step2b.sh &
       fi
       if ! ps aux | grep Step3 | grep -v grep >/dev/null 2>&1
       then 
         `dirname $0`/Step3.sh min &
       fi
      numganymeds=0
   fi
done

finish
