#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

# get current hour
hour=`date +%k`

# define dates depending on the time
if [ $hour -lt 9 ] || [ $hour -gt 19 ]
then
   # get current night
   dates=( `date +%Y/%m/%d --date="-12hour"` )
else
   # get last 3, 6 or 9 nights
   dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
           `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
           `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
           )
fi

cd $mars

# for testing only
anapath=/daq/analysis
# use macro from different mars version until versions are sorted out
mars2=/home/fact/SW.automatic.processing/Mars.svn.2013.04.12

for date in ${dates[@]}
do 
   outpath=$anapath/ratescans/$date
   makedir $outpath
   date2=`echo $date | sed -e 's/\///g'`
   echo "root -q -b $mars2/fact/plots/plotratescan.C\("\"$date2\""\) | tee $logfile | intgrep"
   check1=`root -q -b $mars2/fact/plots/plotratescan.C\("\"$date2\""\) | tee $logfile | intgrep`
   
   case $check1 in
      0)   printprocesslog "INFO plotratescan.C was successful for date "$date2" (check1=$check1)"
           ;;
      *)   printprocesslog "ERROR plotratescan.C failed for date "$date2" (check1=$check1)"
           ;;
   esac

   printprocesslog "INFO rsync output to gate."
   rsync -avn $anapath/ratescans/ gate:/home/factwww/ratescans
done


finish

