// file zerosearch.h
#ifndef __ZEROSEARCH_H
#define __ZEROSEARCH_H

#include "Region.h"
#include <vector>

std::vector<Region> *zerosearch(
    std::vector<float> &input,
    int edge = 1,			// search for transitions on rising edge=1, -1:falling
    unsigned int step = 4,			// search in steps of step
    int VerbosityLevel = 1  // 1 means ... just normal warings are output.
);

size_t ShiftRegionBy(
    std::vector<Region> &src,
    int Shift,
    int VerbosityLevel=0);

size_t EnlargeRegion(std::vector<Region> &src,
    int Left,
    int Right,
    int VerbosityLevel=0);

size_t findAbsMaxInRegions(
    std::vector<Region> &regions,
    std::vector<float> &data,
    int VerbosityLevel=0);

bool compMaxPosOfRegions (Region a, Region b);

size_t removeEqualMaxima(
    std::vector<Region> &regions,
    int VerbosityLevel=0);

size_t removeRegionOnFallingEdge(
  std::vector<Region> &regions,
  unsigned int FallingEdgeWidth = 100,
  int VerbosityLevel=0);


size_t removeRegionWithMaxOnEdge(
    std::vector<Region> &regions,
    unsigned int EdgeWidth=3,
    int VerbosityLevel=0);

size_t removeMaximaBelow(
    std::vector<Region> &regions,
    float threshold = 2.0,
    int VerbosityLevel=0);

size_t removeMaximaAbove(
    std::vector<Region> &regions,
    float threshold= 14.0,
    int VerbosityLevel=0);

size_t removeRegionWithToFlatSlope(
    std::vector<Region> &regions,
    float minSlope=0,
    int VerbosityLevel=0);

Region FindAbsMax(
   std::vector<Region> &regions,
   int VerbosityLevel=0);

size_t calcCFDPositions(
        vector<Region>  &regions,
        vector<float>   &cfd_data
        );

// Calculate the position (sample) of a pulses half maximum
size_t findTimeOfHalfMaxLeft(
    std::vector<Region> &regions,
    std::vector<float> &data,
    float baseline = -0.5,
    int beginRisingEdge = 5,
    int endRisingEdge = 10,
    int VerbosityLevel = 1);

// Get the derived arrival times in terms of the position of selected pulses
// position of the peak
size_t GetMaxPositions(
    vector<Region>  &regions,
    vector<int>     &positions,
    int VerbosityLevel);

// Get the derived arrival times in terms of the position of selected pulses
// rising edges
size_t GetEdgePositions(
    vector<Region>  &regions,
    vector<int>     &positions,
    int VerbosityLevel);


#endif
