#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

#root=/opt/root_svn/bin/thisroot.sh
#source $root
#factpath=/home/fact/FACT++.in-run-fad-loss

#anapath=/loc_data/analysis

sources=( 1 2 5 7 )
numganymeds=0

for source in ${sources[@]}
do 
   # getting all nights
   printprocesslog "INFO get all nights for source "$source
   dirs=( `find $anapath/$source/datasets_run -maxdepth 3 -mindepth 3 -type d 2>/dev/null | sort` )
   #nights=1
   # write data set file
   dspath=$anapath/$source/datasets_night
   makedir $dspath
   for (( i=1 ; i<=${#dirs[@]} ; i++ ))
   do 
      numdsfiles=`find ${dirs[$i-1]} -type f | wc -l`
      imgpath=`echo ${dirs[$i-1]} | sed -e 's/datasets_run/star/'`
      numimgfiles=`find $imgpath -type f -name '*_I.root' | wc -l`
      echo ${dirs[$i-1]}" "$numdsfiles" "$numimgfiles
      night=`echo ${dirs[$i-1]} | cut -d/ -f6-8 | sed -e 's/\///g'`
      echo $night
      dsfile=$dspath"/dataset"$night".txt"
      numold=`cat $dsfile | wc -l`
      echo ${dirs[$i-1]}" "$numdsfiles" "$numimgfiles" "$numold
      echo $dsfile
      printprocesslog "INFO writing dataset file "$dsfile
      echo "INFO writing dataset file "$dsfile
      #cat ${dirs[$i-1]}/dataset*.txt
      cat ${dirs[$i-1]}/dataset*.txt > $dsfile
      # process only if ganymedlogfiles is not yet there
      logfile=`echo $dsfile | sed -e 's/datasets/ganymed/' -e 's/dataset//' -e 's/[.]txt/-ganymed[.]log/'`
      echo $logfile
      # this does not work as there might be dataset files already pr
      #if [ $numdsfiles -ne $numimgfiles ]
      if [ $numold -lt $numimgfiles ]
      then
         printprocesslog "INFO remove $logfiles (new files added to dataset) " 
         rm $logfile
      fi
      if ! ls $logfile >/dev/null 2>&1
      then
         echo "`dirname $0`/RunGanymed.sh $source $dsfile"
         `dirname $0`/RunGanymed.sh $source $dsfile
         numganymeds=`echo " $numganymeds + 1 " | bc -l`
      fi
   done 
   
#   # get list of dataset files for 1 night as starting point
#   printprocesslog "INFO get list of dataset files for "$nights" nights"
#   files=( `find $dspath -type f -name 'dataset*.txt' | sort` )
#   nightsold=1
#   # loop over data set files
#   # copy always 2 in one new file for double observation time
#   while [ ${#files[@]} -gt 1 ]
#   do
#      # get double observation time and path for datasets
#      nights=`echo " $nightsold + $nightsold " | bc -l `
#      dspathold=$dspath
#      dspath=$anapath"/"$source"/datasets"`printf %04d $nights`"nights"
#      makedir $dspath
#      # loop over already existing data set files
#      for (( i=0 ; i<=${#files[@]} ; i++ ))
#      do 
#         # number of 1st and 2nd old dataset file
#         num1=`echo " $i + $i + 1" | bc -l `
#         num2=`echo " $i + $i + 2 " | bc -l `
#         # number of new dataset file
#         dsnum=`echo " $i + 1 " | bc -l `
#         # continue only if 2 dataset files are left
#         if ! [ ${files[$num1]} ]
#         then
#            break
#         fi
#         ds1=$dspathold"/dataset"$num1".txt"
#         ds2=$dspathold"/dataset"$num2".txt"
#         dsfile=$dspath"/dataset"$dsnum".txt"
#         # copy two old into one new dataset file
#         printprocesslog "INFO writing dataset "$dsfile
#         echo "INFO writing dataset "$dsfile
#         cat $ds1 > $dsfile
#         cat $ds2 >> $dsfile
#         # process only if ganymedlogfiles is not yet there
#         logfile=`echo $dsfile | sed -e 's/datasets/ganymed/' -e 's/dataset//' -e 's/[.]txt/-ganymed[.]log/'`
#         if ! ls $logfile  >/dev/null 2>&1
#         then
#            `dirname $0`/RunGanymed.sh $source $dsfile
#            numganymeds=`echo " $numganymeds + 1 " | bc -l`
#         fi
#      done
#      # get list of new dataset files
#      printprocesslog "INFO get list of dataset files for "$nights" nights"
#      files=( `find $dspath -type f -name 'dataset*.txt' | sort` )
#      nightsold=$nights
#   done
   
    echo "found "$numganymeds" ganymeds."
   #if [ $numganymeds -gt 0 ]
   #then 
   #    if ! ps aux | grep Step3 | grep -v grep >/dev/null 2>&1
   #    then 
   #      `dirname $0`/Step3.sh nights &
   #    fi
   #   numganymeds=0
   #fi
   
done

finish
