#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

#root=/opt/root_svn/bin/thisroot.sh
#source $root
#factpath=/home/fact/FACT++.in-run-fad-loss
#export LD_LIBRARY_PATH=./:$LD_LIBRARY_PATH

mars=/home/fact/Mars
cd $mars
pwd
# use macro from different mars version until versions are sorted out
mars2=/home/fact/SW.automatic.processing/Mars.svn.2013.04.12

if ! [ "$1" = "run" ] && ! [ "$1" = "night" ]
then 
   #echo "wrong option "$1" (only min and nights valid)."
   echo "wrong option "$1" (only run and night valid)."
   finish
fi

if [ "$1" = "run" ]
then 
   tablenam=$resulttable1
fi

if [ "$1" = "night" ]
then
   tablenam=$resulttable2
fi

# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )
#dates=( `find -L $ziprawdata -mindepth 3 -type d | sort -r | sed "s/\${ziprawdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

dates=( "2013/04/19" )

# source info on daq in /loc_data/analysis/sources.txt 
#    (dump of DB scheduling.sources)

timebins=( 5 10 20 30 40 60 90 120 180 240 300 360 )

for date in ${dates[@]}
do 
   date2=`echo $date | sed -e 's/\///g'`
   query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$date2" AND fSourceKey > 0 AND fRunTypeKEY=1 GROUP BY fSourceKey "
   sources=( `sendquery` )
   for source in ${sources[@]}
   do 
      echo $source
      printprocesslog "INFO processing files for source "$source
      outpath=$anapath/lightcurves/$date
      makedir $outpath

      for timebin in ${timebins[@]}
      do 
         # doing the plots for one night
         logfile=$outpath"/lightcurve"$source"_"$timebin"min_"$date2".log"
         outfile=$outpath"/lightcurve"$source"_"$timebin"min_"$date2".root"
         echo $outfile
         printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin "$timebin" night "$date2
      
	 check1=`root -q -b $mars2/fact/analysis/lightcurve.C+\($source\,$date2\\,$date2\,$timebin\,"\"$resulttable1"\"\,"\"$outfile\""\) | tee $logfile | intgrep`
      
         case $check1 in
            0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" night "$date2" (check1=$check1)"
                 ./showplot -b --save-as-png $outfile
                 ;;
            1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" night "$date2", but nothing to plot (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin "$timebin" night "$date2" (check1=$check1)"
                 ;;
         esac

         # doing the plots for all nights
         logfile=$outpath"/lightcurve"$source"_"$timebin"min_all.log"
         outfile=$outpath"/lightcurve"$source"_"$timebin"min_all.root"
         echo $outfile
         printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin "$timebin" night "$date2" all nights"
      
	 check1=`root -q -b $mars2/fact/analysis/lightcurve.C+\($source\,$firstnight\\,$date2\,$timebin\,"\"$resulttable1"\"\,"\"$outfile\""\) | tee $logfile | intgrep`
      
         case $check1 in
            0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" night "$date2" all nights (check1=$check1)"
                 ./showplot -b --save-as-png $outfile
                 ;;
            1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" night "$date2" all nights, but nothing to plot (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin "$timebin" night "$date2" all nights (check1=$check1)"
                 ;;
         esac
      done
   done
   printprocesslog "INFO rsync output of source "$source" to gate."
   rsync -av $anapath/lightcurves/ gate:/home/factwww/lightcurves
done


finish

