#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/FillNumEvts-"$datetime".log"
date >> $logfile

# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )
#dates=( `find -L $ziprawdata -mindepth 3 -type d | sort -r | sed "s/\${ziprawdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

#dates=( "2013/04/13" )

printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

echo ${dates[@]}

mars=/home/fact/Mars
cd $mars
pwd
# use macro from different mars version until versions are sorted out
mars2=/home/fact/SW.automatic.processing/Mars.svn.2013.04.12

# do filling of aux data 
for date in ${dates[@]}
do 
   date2=`echo $date | sed -e 's/\///g'`
   runnumber=`echo $date | sed -e 's/\///g'`
   inpath=$anapath"/"$source
   
   query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$date2" AND fSourceKey > 0 AND fRunTypeKEY=1 GROUP BY fSourceKey "
   sources=( `sendquery` )
   for source in ${sources[@]}
   do 
      echo "processing "$source
      
      inpath=$anapath/$source
      echo "run numevts.C for night "$runnumber" (run-wise processing) "
      root -q -b -l $mars2/fact/processing/numevents.C\("\"$runnumber"\"\,"\"$inpath"\"\,"\"$resulttable1"\"\,kFALSE\,kFALSE\)

      #echo "run numevts.C for night "$runnumber" (night-wise processing) "
      #root -q -b -l fact/processing/numevts.C\("\"$runnumber"\"\,"\"$inpath"\"\,"\"$resulttable2"\"\,kFALSE\,kTRUE\)
   done

done

finish


