/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

void readMagic(const char *fname="~/data/Gamma_0_7*.root")
{
    MParList plist;

    MGeomCamMagic geomcam;
    MHillasExt    hillas;
    MTaskList     tlist;

    plist.AddToList(&geomcam);
    plist.AddToList(&hillas);
    plist.AddToList(&tlist);

    MReadMarsFile     read("Events", fname);
    read.DisableAutoScheme();

    MPrint            print("MMcEvt");
    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotCalc      ncalc;
    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();
    MClone            clone("MCerPhotEvt");
    MImgCleanStd      clean;
    MHillasCalc       hcalc;


    tlist.AddToList(&read);
    tlist.AddToList(&print);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&blind);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCamDisplay display(&geomcam);
    display.Draw();

    while (tlist.Process())
    {
        cout << "Event #" << read.GetEventNum() ":" << endl;

        display.DrawPhotNum((MCerPhotEvt*)clone.GetClone());

        if (!HandleInput())
            break;

        hillas.Print();
	hillas.Draw();

        display.DrawPhotNum((MCerPhotEvt*)plist.FindObject("MCerPhotEvt"));

        if (!HandleInput())
            break;
    } 

    evtloop.PostProcess();
}

