#ifndef MARS_MHillasExt
#define MARS_MHillasExt

#ifndef MARS_MHillas
#include "MHillas.h"
#endif

class MGeomCam;
class MCerPhotEvt;

class MHillasExt : public MHillas
{
private:
    // for description see MExtHillas.cc
    Float_t fConc;    // [ratio] concentration ratio: sum of the two highest pixels / fSize
    Float_t fConc1;   // [ratio] concentration ratio: sum of the highest pixel / fSize
    Float_t fAsym;    // [mm]    fDist minus dist: center of ellipse, highest pixel
    Float_t fM3Long;  // [mm]    3rd moment (e-weighted) along major axis
    Float_t fM3Trans; // [mm]    3rd moment (e-weighted) along minor axis

public:
    MHillasExt(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetConc() const    { return fConc; }
    Float_t GetConc1() const   { return fConc1; }
    Float_t GetAsym() const    { return fAsym; }
    Float_t GetM3Long() const  { return fM3Long; }
    Float_t GetM3Trans() const { return fM3Trans; }

    Int_t Calc(const MGeomCam &geom, const MCerPhotEvt &pix);

    void Print(Option_t *opt=NULL) const;

    void Set(const TArrayF &arr);

    //void AsciiRead(ifstream &fin);
    //void AsciiWrite(ofstream &fout) const;

    ClassDef(MHillasExt, 1) // Storage Container for extended Hillas Parameter
};
#endif
