#ifndef MARS_MCamDisplay
#define MARS_MCamDisplay

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class TBox;
class TText;
class TArrow;
class TVirtualPad;

class MGeomCam;
class MHexagon;
class MCerPhotEvt;
class MCerPhotPix;
class MImgCleanStd;
class MPedestalPix;
class MPedestalCam;

class MCamDisplay : public TObject
{
private:
    MGeomCam      *fGeomCam;     // pointer to camera geometry

    Bool_t         fAutoScale;   // indicating the autoscale function

    UInt_t         fNumPixels;   // number of pixels in the present geometry
    Float_t        fRange;       // the range in millimeters of the present geometry

    Int_t          fColors[50];

    TArrow        *fArrowX;      // Coordinate System
    TArrow        *fArrowY;      // Coordinate System

    TText         *fLegRadius;   // Coordinate System
    TText         *fLegDegree;   // Coordinate System

    TClonesArray  *fPixels;      // array of all hexagons
    TClonesArray  *fLegend;      // array of all color bars
    TClonesArray  *fLegText;     // array of all texts

    UInt_t         fW;           // Width of canvas
    UInt_t         fH;           // Height of canvas
    TVirtualPad   *fDrawingPad;  // pad in which we are drawing
    Bool_t         fIsAllocated;

    TBox  *GetBox(Int_t i)  { return (TBox*) fLegend->At(i); }
    TText *GetText(Int_t i) { return (TText*)fLegText->At(i); }

    MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

    void  SetPixColor(const MCerPhotPix &pix, const Int_t i, Float_t min, Float_t max);
    void  SetPixColorRatio(const MCerPhotPix &pix, Float_t min, Float_t max);
    void  SetPixColorLevel(const MCerPhotPix &pix, Float_t lvl1, Float_t lvl2);
    void  SetPixColorError(const MCerPhotPix &pix, const Int_t i, Float_t min, Float_t max);
    void  SetPixColorPedestal(const MPedestalPix &pix, Int_t i, Float_t min, Float_t max);
    Int_t GetColor(Float_t val, Float_t min, Float_t max);

    void UpdateLegend(Float_t min, Float_t max);
    void Paint(Option_t *option="");

public:
    MCamDisplay(MGeomCam *geom);
    ~MCamDisplay();

    void SetAutoScale(Bool_t input=kTRUE) { fAutoScale = input; }
    void DrawPhotNum(const MCerPhotEvt *event);
    void DrawRatio(const MCerPhotEvt *event);
    void DrawLevels(const MCerPhotEvt *event, Float_t lvl1, Float_t lvl2);
    void DrawErrorPhot(const MCerPhotEvt *event);
    void DrawLevels(const MCerPhotEvt *event, const MImgCleanStd &clean);
    void DrawPedestals(const MPedestalCam *event);

    void DrawPixelNumbers();

    virtual void  Reset();
    virtual void  Draw(Option_t *option="");
    virtual void  SavePrimitive(ofstream &out, Option_t *);
    virtual Int_t DistancetoPrimitive(Int_t px, Int_t py);
    //virtual void  ExecuteEvent(Int_t event, Int_t px, Int_t py);

    void SetPalette(Int_t ncolors, Int_t *colors);

    ClassDef(MCamDisplay, 0) // Displays the magic camera
};

#endif
