// @(#)root/tree:$Id: MBasketSQL.cxx 43518 2012-03-28 01:04:07Z pcanal $
// Author: Philippe Canal and al. 08/2004

/*************************************************************************
 * Copyright (C) 1995-2000, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// MBasketSQL                                                           //
//                                                                      //
// Implement TBasket for a SQL backend                                  //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#ifndef TBASKETSQL_CXX
#define TBASKETSQL_CXX

#include "TBasket.h"
#include "TTree.h"
#include "TBranch.h"
#include "TFile.h"
#include "TMath.h"
#include "MBasketSQL.h"
#include <Riostream.h>
#include <vector>
#include "MTreeSQL.h"
#include "MBufferSQL.h"

ClassImp(MBasketSQL)

namespace std {} using namespace std;

//_________________________________________________________________________
MBasketSQL::MBasketSQL() : TBasket(), fResultPtr(0), fRowPtr(0), fInsertQuery(0)
{
   // Default constructor.

}

//_________________________________________________________________________
MBasketSQL::MBasketSQL(const char *name, const char *title, TBranch *branch, 
                         TSQLResult ** rs, TString *insert_query, 
                         vector<Int_t> *vc, TSQLRow **r) :
  fResultPtr(rs),fRowPtr(r)
{ 
   // Regular constructor.

   SetName(name);
   SetTitle(title);
   fClassName   = "MBasketSQL";
   fBufferSize  = branch->GetBasketSize();
   fNevBufSize  = branch->GetEntryOffsetLen();
   fNevBuf      = 0;
   fEntryOffset = 0;  //Must be set to 0 before calling Sizeof
   fDisplacement= 0;  //Must be set to 0 before calling Sizeof
   fBuffer      = 0;  //Must be set to 0 before calling Sizeof
   fInsertQuery = insert_query;

   if (vc==0) {
      fBufferRef = 0;
   } else {
      fBufferRef = new MBufferSQL(TBuffer::kWrite, fBufferSize, vc, fInsertQuery, fRowPtr);
   }
   fHeaderOnly  = kTRUE;
   fLast        = 0; // Must initialize before calling Streamer()
   //Streamer(*fBufferRef);
   fBuffer      = 0;
   fBranch      = branch;
   fHeaderOnly  = kFALSE;
   branch->GetTree()->IncrementTotalBuffers(fBufferSize);

}

//_________________________________________________________________________
MBasketSQL::~MBasketSQL()
{
   // Destructor
}

//_________________________________________________________________________
void MBasketSQL::CreateBuffer(const char *name, TString title, 
                              vector<Int_t> *vc, 
                              TBranch *branch, TSQLResult ** rs)
{
   // Create a TSQLBuffer for this basket.

   fResultPtr = rs;
   SetName(name);
   SetTitle(title);
   fClassName   = "MBasketSQL";
   fBufferSize  = branch->GetBasketSize();
   fNevBufSize  = branch->GetEntryOffsetLen();
   fNevBuf      = 0;
   fEntryOffset = 0;  //Must be set to 0 before calling Sizeof
   fDisplacement= 0;  //Must be set to 0 before calling Sizeof
   fBuffer      = 0;  //Must be set to 0 before calling Sizeof

   if(vc==0) {
      fBufferRef = 0;
      Error("CreateBuffer","Need a vector of columns\n");
   } else {    
      fBufferRef   = new MBufferSQL(TBuffer::kWrite, fBufferSize, vc, fInsertQuery, fRowPtr);
   }
   fHeaderOnly  = kTRUE;
   fLast        = 0; 
   //Streamer(*fBufferRef);
   fBuffer      = 0;
   fBranch      = branch;
   fHeaderOnly  = kFALSE;
   branch->GetTree()->IncrementTotalBuffers(fBufferSize);
}

//_________________________________________________________________________
void MBasketSQL::PrepareBasket(Long64_t entry)
{
   // Prepare the basket for the next entry.

   ((MBufferSQL*)fBufferRef)->ResetOffset();
   ((MTreeSQL*)fBranch->GetTree())->PrepEntry(entry);
   fBufferRef->Reset();
}

//_________________________________________________________________________
Int_t MBasketSQL::ReadBasketBytes(Long64_t , TFile *)
{
   // See TBasket::ReadBasketBytes.  This is not implemented in MBasketSQL.

   Error("ReadBasketBytes","This member function should not be called!");
   return 0;
}

//_________________________________________________________________________
Int_t MBasketSQL::ReadBasketBuffers(Long64_t , Int_t, TFile *)
{	 
   // See TBasket::ReadBasketBuffers.  This is not implemented in MBasketSQL.

   Error("ReadBasketBuffers","This member function should not be called!");
   return 0;
}

//_________________________________________________________________________
void MBasketSQL::Reset()
{	 
   // See TBasket::Reset

   TBasket::Reset();
}


//_________________________________________________________________________
void MBasketSQL::Update(Int_t, Int_t) 
{
   // See TBasket::Update.

   ((MBufferSQL*)fBufferRef)->ResetOffset();
   fNevBuf++;
}


#endif
