// @(#)root/tree:$Id: MBufferSQL.cxx 43518 2012-03-28 01:04:07Z pcanal $
// Author: Philippe Canal and al. 08/2004

/*************************************************************************
 * Copyright (C) 1995-2000, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// MBufferSQL                                                           //
//                                                                      //
// Implement TBuffer for a SQL backend                                  //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <vector>
#include <stdio.h>
#include "TError.h"

#include "MBufferSQL.h"
#include "TSQLResult.h"
#include "TSQLRow.h"
#include <stdlib.h>

using namespace std;

ClassImp(MBufferSQL);

//________________________________________________________________________
MBufferSQL::MBufferSQL(TBuffer::EMode mode, vector<Int_t> *vc, 
                       TString *insert_query, TSQLRow ** r) : 
   TBufferFile(mode),
   fColumnVec(vc), fInsertQuery(insert_query), fRowPtr(r) 
{
   // Constructor.

   fIter = fColumnVec->begin();
}

//________________________________________________________________________
MBufferSQL::MBufferSQL(TBuffer::EMode mode, Int_t bufsiz, vector<Int_t> *vc, 
                       TString *insert_query, TSQLRow ** r) : 
   TBufferFile(mode,bufsiz), 
   fColumnVec(vc), fInsertQuery(insert_query), fRowPtr(r) 
{
   // Constructor.

   fIter = fColumnVec->begin();
}

//________________________________________________________________________
MBufferSQL::MBufferSQL(TBuffer::EMode mode, Int_t bufsiz, vector<Int_t> *vc, 
                       TString *insert_query, TSQLRow ** r,
                       void *buf, Bool_t adopt) : 
   TBufferFile(mode,bufsiz,buf,adopt),
   fColumnVec(vc), fInsertQuery(insert_query), fRowPtr(r) 
{
   // Constructor.

   fIter = fColumnVec->begin();
}

//________________________________________________________________________
MBufferSQL::MBufferSQL() : TBufferFile(), fColumnVec(0),fInsertQuery(0),fRowPtr(0)
{
   // Constructor.

}

//________________________________________________________________________
MBufferSQL::~MBufferSQL() 
{
   // Destructo.

   delete fColumnVec;
}

//________________________________________________________________________
void MBufferSQL::ReadBool(Bool_t &b) 
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   b = (Bool_t)atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Bool_t&)","Error reading Bool_t");
}

//________________________________________________________________________
void MBufferSQL::ReadChar(Char_t &c)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   c = (Char_t)atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Char_t&)","Error reading Char_t");
}

//________________________________________________________________________
void MBufferSQL::ReadShort(Short_t &h)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   h = (Short_t)atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Short_t&)","Error reading Short_t");
}

//________________________________________________________________________
void MBufferSQL::ReadInt(Int_t &i)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   i = atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Int_t&)","Error reading Int_t");
}

//________________________________________________________________________
void MBufferSQL::ReadFloat(Float_t &f)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   f = atof(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Float_t&)","Error reading Float_t");
}

//________________________________________________________________________
void MBufferSQL::ReadLong(Long_t &l)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   l = atol(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Long_t&)","Error reading Long_t");
}

//________________________________________________________________________
void MBufferSQL::ReadDouble(Double_t &d)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   d = atof(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(Double_t&)","Error reading Double_t");
}


//________________________________________________________________________
void MBufferSQL::WriteBool(Bool_t    b)
{
   // Operator<<

   (*fInsertQuery) += b;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteChar(Char_t    c)
{
   // Operator<<

   (*fInsertQuery) += c;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteShort(Short_t   h)
{
   // Operator<<

   (*fInsertQuery) += h;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteInt(Int_t     i)
{
   // Operator<<

   (*fInsertQuery) += i;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteLong(Long_t    l)
{
   // Operator<<

   (*fInsertQuery) += l;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteFloat(Float_t   f)
{
   // Operator<<

   (*fInsertQuery) += f;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteDouble(Double_t  d)
{
   // Operator<<

   (*fInsertQuery) += d;
   (*fInsertQuery) += ",";
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadUChar(UChar_t& uc)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   uc = (UChar_t)atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(UChar_t&)","Error reading UChar_t");
}

//________________________________________________________________________
void MBufferSQL::ReadUShort(UShort_t& us)
{
   // Operator>>
   const char *ptr = (*fRowPtr)->GetField(*fIter);

   us = (UShort_t)atoi(ptr?ptr:"");

   if (fIter != fColumnVec->end()) ++fIter;

   if(ptr==0) Error("operator>>(UShort_t&)","Error reading UShort_t");
}

//________________________________________________________________________
void MBufferSQL::ReadUInt(UInt_t& ui)
{
   // Operator>>

   TString val = (*fRowPtr)->GetField(*fIter);
   Int_t code = sscanf(val.Data(), "%u",&ui);
   if(code == 0) Error("operator>>(UInt_t&)","Error reading UInt_t");

   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadULong(ULong_t& ul)
{
   // Operator>>

   TString val = (*fRowPtr)->GetField(*fIter);
   Int_t code = sscanf(val.Data(), "%lu",&ul);
   if(code == 0) Error("operator>>(ULong_t&)","Error reading ULong_t");

   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadLong64(Long64_t &ll)
{
   // Operator>>

   TString val = (*fRowPtr)->GetField(*fIter);
   Int_t code = sscanf(val.Data(), "%lld",&ll);
   if(code == 0) Error("operator>>(ULong_t&)","Error reading Long64_t");

   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadULong64(ULong64_t &ull)
{
   // Operator>>

   TString val = (*fRowPtr)->GetField(*fIter);
   Int_t code = sscanf(val.Data(), "%llu",&ull);
   if(code == 0) Error("operator>>(ULong_t&)","Error reading ULong64_t");

   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadCharP(Char_t *str)
{
   // Operator>>

   strcpy(str,(*fRowPtr)->GetField(*fIter));  // Legacy interface, we have no way to know the user's buffer size ....
   if (fIter != fColumnVec->end()) ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadTString(TString   &)
{
   // Operator>>

   //strcpy(str,(*fRowPtr)->GetField(*fIter));
   //if (fIter != fColumnVec->end()) ++fIter;
   printf("ERROR NOT IMPLEMENTED\n");
}

//________________________________________________________________________
void MBufferSQL::WriteTString(const TString   &)
{
   // Operator>>

   //strcpy(str,(*fRowPtr)->GetField(*fIter));
   //if (fIter != fColumnVec->end()) ++fIter;
   printf("ERROR NOT IMPLEMENTED\n");
}

// Method to send to database.

//________________________________________________________________________
void MBufferSQL::WriteUChar(UChar_t uc)
{
   // Operator<<

   (*fInsertQuery) += uc;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteUShort(UShort_t us)
{
   // Operator<<

   (*fInsertQuery) += us;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteUInt(UInt_t ui)
{
   // Operator<<

   (*fInsertQuery) += ui;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteULong(ULong_t ul)
{
   // Operator<<

   (*fInsertQuery) += ul;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteLong64(Long64_t ll)
{
   // Operator<<

   (*fInsertQuery) += ll;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteULong64(ULong64_t ull)
{
   // Operator<<

   (*fInsertQuery) += ull;
   (*fInsertQuery) += ",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteCharP(const Char_t *str)
{
   // Operator<<

   (*fInsertQuery) += "\"";
   (*fInsertQuery) += str;
   (*fInsertQuery) += "\",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Bool_t *b, Int_t n)
{
   // WriteFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += b[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Char_t *c, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += (Short_t)c[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArrayString(const Char_t *c, Int_t /* n */)
{
   // WriteFastArray SQL implementation.   

   (*fInsertQuery) += "\"";
   (*fInsertQuery) += c;
   (*fInsertQuery) += "\",";
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const UChar_t *uc, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += uc[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Short_t *h, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += h[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const UShort_t *us, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += us[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Int_t     *ii, Int_t n)
{
   // WriteFastArray SQL implementation.   

    //   cerr << "Column: " <<*fIter << "   i:" << *ii << endl;
   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += ii[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const UInt_t *ui, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += ui[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Long_t    *l, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery)+= l[i];
      (*fInsertQuery)+= ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const ULong_t   *ul, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += ul[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Long64_t  *l, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += l[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const ULong64_t *ul, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += ul[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Float_t   *f, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += f[i];
      (*fInsertQuery) += ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(const Double_t  *d, Int_t n)
{
   // WriteFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {
      (*fInsertQuery) += d[i];
      (*fInsertQuery )+= ",";
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::WriteFastArray(void*, const TClass*, Int_t, TMemberStreamer *)
{
   // WriteFastArray SQL implementation.   

   Fatal("riteFastArray(void*, const TClass*, Int_t, TMemberStreamer *)","Not implemented yet");
}

//________________________________________________________________________
Int_t MBufferSQL::WriteFastArray(void **, const TClass*, Int_t, Bool_t, TMemberStreamer*)
{
   // WriteFastArray SQL implementation.   

   Fatal("WriteFastArray(void **, const TClass*, Int_t, Bool_t, TMemberStreamer*)","Not implemented yet");
   return 0;
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Bool_t *b, Int_t n)
{
   // ReadFastArray SQL implementation.   

   for(int i=0; i<n; ++i) {  
      b[i] = (Bool_t)atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Char_t *c, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      c[i] = (Char_t)atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArrayString(Char_t *c, Int_t /* n */)
{
   // ReadFastArray SQL implementation.   
   strcpy(c,((*fRowPtr)->GetField(*fIter)));
   ++fIter;
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(UChar_t *uc, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      uc[i] = (UChar_t)atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Short_t *s, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      s[i] = (Short_t)atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(UShort_t *us, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      us[i] = (UShort_t)atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArray(Int_t *in, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      in[i] = atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArray(UInt_t *ui, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      ui[i] = atoi((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Long_t *l, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      l[i] = atol((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(ULong_t   *ul, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      (*this) >> ul[i];
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Long64_t  *ll, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      (*this) >> ll[i];
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(ULong64_t *ull, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      (*this) >> ull[i];
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Float_t   *f, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      f[i] = atof((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void MBufferSQL::ReadFastArray(Double_t *d, Int_t n)
{
   // ReadFastArray SQL implementation.   
   for(int i=0; i<n; ++i) {  
      d[i] = atof((*fRowPtr)->GetField(*fIter));
      ++fIter;
   }
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArrayFloat16(Float_t  *, Int_t , TStreamerElement *)
{
   // ReadFastArray SQL implementation.   
   Fatal("ReadFastArrayFloat16(Float_t  *, Int_t , TStreamerElement *)","Not implemented yet");
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArrayDouble32(Double_t  *, Int_t , TStreamerElement *)
{
   // ReadFastArray SQL implementation.   
   Fatal("ReadFastArrayDouble32(Double_t  *, Int_t , TStreamerElement *)","Not implemented yet");
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArray(void  *, const TClass *, Int_t, TMemberStreamer *, const TClass *)
{
   // ReadFastArray SQL implementation.   
   Fatal("ReadFastArray(void  *, const TClass *, Int_t, TMemberStreamer *, const TClass *)","Not implemented yet");
}

//________________________________________________________________________
void     MBufferSQL::ReadFastArray(void **, const TClass *, Int_t, Bool_t, TMemberStreamer *, const TClass *)
{
   // ReadFastArray SQL implementation.   
   Fatal("ReadFastArray(void **, const TClass *, Int_t, Bool_t, TMemberStreamer *, const TClass *)","Not implemented yet");
}

//________________________________________________________________________
void MBufferSQL::ResetOffset() 
{
   // Reset Offset.
   fIter = fColumnVec->begin();
}

#if 0
//________________________________________________________________________
void MBufferSQL::insert_test(const char* dsn, const char* usr, 
                             const char* pwd, const TString& tblname) 
{
   TString str;
   TString select = "select * from ";
   TString sql;
   TSQLStatement* stmt; 
   sql = select + "ins";

   con = gSQLDriverManager->GetConnection(dsn,usr,pwd);

   if(!con)
      printf("\n\n\nConnection NOT Successful\n\n\n");
   else
      printf("\n\n\nConnection Sucessful\n\n\n");



   stmt = con->CreateStatement(0, odbc::ResultSet::CONCUR_READ_ONLY);

   ptr = stmt->ExecuteQuery(sql.Data()); 
   if(!ptr) printf("No recorSet found!");	

   ptr->Next();
   ptr->MoveToInsertRow();
   cerr << "IsAfterLast(): " << ptr->IsAfterLast() << endl;
   ptr->UpdateInt(1, 5555);
   ptr->InsertRow();
   con->Commit();

   ptr1 = stmt->ExecuteQuery(sql.Data());

}
#endif
