----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    11:59:40 01/19/2010 
-- Design Name:    
-- Module Name:    FTU_top - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Top level entity of FACT FTU board 										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_top is
  port(
    ext_clk   : IN  STD_LOGIC;                     --external clock from FTU board
    brd_add   : IN  STD_LOGIC_VECTOR(7 downto 0);  --global board address
    patch1    : IN  STD_LOGIC;                     --logic signal from first trigger patch
    patch2    : IN  STD_LOGIC;                     --logic signal from second trigger patch
    patch3    : IN  STD_LOGIC;                     --logic signal from third trigger patch
    patch4    : IN  STD_LOGIC;                     --logic signal from fourth trigger patch
    trig_prim : IN  STD_LOGIC;                     --logic signal from n-out-of-4 circuit
    miso      : IN  STD_LOGIC;                     --serial data from DAC
    rx        : IN  STD_LOGIC;                     --serial data from FTM
    enables   : OUT STD_LOGIC_VECTOR(35 downto 0); --individual enables for analog inputs
    clr       : OUT STD_LOGIC;                     --clear signal to DAC
    cs_ld     : OUT STD_LOGIC;                     --chip select or load to DAC
    sck       : OUT STD_LOGIC;                     --serial clock to DAC
    mosi      : OUT STD_LOGIC;                     --serial data to DAC
    tx        : OUT STD_LOGIC                      --serial data to FTM
  );
end FTU_top;

architecture Behavioral of FTU_top is

  component FTU_dac_dcm
    port(
      CLKIN_IN        : IN  STD_LOGIC; 
      RST_IN          : IN  STD_LOGIC; 
      CLKFX_OUT       : OUT STD_LOGIC; 
      CLKIN_IBUFG_OUT : OUT STD_LOGIC; 
      LOCKED_OUT      : OUT STD_LOGIC
    );
  end component;
  
  component FTU_dac_control
    port(
      clk      : IN  STD_LOGIC;
      reset    : IN  STD_LOGIC;
      miso     : IN  STD_LOGIC;
      clr      : OUT STD_LOGIC;
      mosi     : OUT STD_LOGIC;
      sck      : OUT STD_LOGIC;
      cs_ld    : OUT STD_LOGIC
    );
  end component;

  signal clk_sig   : STD_LOGIC;
  signal reset_sig : STD_LOGIC;
  signal miso_sig  : STD_LOGIC;
  signal clr_sig   : STD_LOGIC;
  signal mosi_sig  : STD_LOGIC;
  signal sck_sig   : STD_LOGIC;
  signal cs_ld_sig : STD_LOGIC;    

  signal clk_5M_sig : STD_LOGIC;
  
begin

  clk_sig   <= ext_clk;
  reset_sig <= '0';--where to get this from?
  miso_sig  <= miso;

  clr   <= clr_sig;
  mosi  <= mosi_sig;
  sck   <= sck_sig;
  cs_ld <= cs_ld_sig;

  Inst_FTU_dac_dcm : FTU_dac_dcm
    port map(
      CLKIN_IN => clk_sig,
      RST_IN => reset_sig,
      CLKFX_OUT => clk_5M_sig,
      CLKIN_IBUFG_OUT => open,
      LOCKED_OUT => open
    );
  
  Inst_FTU_dac_control : FTU_dac_control
    port map(
      clk   => clk_5M_sig,
      reset => reset_sig,
      miso  => miso_sig,
      clr   => clr_sig,
      mosi  => mosi_sig,
      sck   => sck_sig,
      cs_ld => cs_ld_sig      
    );

end Behavioral;

--What is missing?
--UART  
--registers (enables, DAC values etc.)
--rate counters
--main state machine for FTU: talks to DAC, reads counters, listens to UART
  
