--------------------------------------------------------------------------------
-- Company:       ETH Zurich, Institute for Particle Physics
-- Engineer:      P. Vogler, Q. Weitzel
--
-- Create Date:   14:57:43 01/19/2010
-- Design Name:   
-- Module Name:   /home/qweitzel/FPGA/FACT/FTU/source/FTU_top_tb.vhd
-- Project Name:  FTUsim01
-- Target Device:  
-- Tool versions:  
-- Description:   Testbench for top level entity of FACT FTU board 
-- 
-- VHDL Test Bench Created by ISE for module: FTU_top
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;
 
entity FTU_top_tb is
end FTU_top_tb;

architecture behavior of FTU_top_tb is 

  -- Component Declaration for the Unit Under Test (UUT)
 
  component FTU_top
    port(
      ext_clk   : IN  STD_LOGIC;
      brd_add   : IN  STD_LOGIC_VECTOR(7 downto 0);
      patch1    : IN  STD_LOGIC;
      patch2    : IN  STD_LOGIC;
      patch3    : IN  STD_LOGIC;
      patch4    : IN  STD_LOGIC;
      trig_prim : IN  STD_LOGIC;
      miso      : IN  STD_LOGIC;
      rx        : IN  STD_LOGIC;
      enables   : OUT STD_LOGIC_VECTOR(35 downto 0);
      clr       : OUT STD_LOGIC;
      cs_ld     : OUT STD_LOGIC;
      sck       : OUT STD_LOGIC;
      mosi      : OUT STD_LOGIC;
      tx        : OUT STD_LOGIC
    );
  end component;
    
  --Inputs
  signal ext_clk   : STD_LOGIC := '0';
  signal brd_add   : STD_LOGIC_VECTOR(7 downto 0) := (others => '0');
  signal patch1    : STD_LOGIC := '0';
  signal patch2    : STD_LOGIC := '0';
  signal patch3    : STD_LOGIC := '0';
  signal patch4    : STD_LOGIC := '0';
  signal trig_prim : STD_LOGIC := '0';
  signal miso      : STD_LOGIC := '0';
  signal rx        : STD_LOGIC := '0';

  --Outputs
  signal enables : STD_LOGIC_VECTOR(35 downto 0);
  signal clr     : STD_LOGIC;
  signal cs_ld   : STD_LOGIC;
  signal sck     : STD_LOGIC;
  signal mosi    : STD_LOGIC;
  signal tx      : STD_LOGIC;
  
  -- Clock period definitions
  constant ext_clk_period : TIME := 20 ns;
 
begin
 
  -- Instantiate the Unit Under Test (UUT)
  uut: FTU_top
    port map(
      ext_clk   => ext_clk,
      brd_add   => brd_add,
      patch1    => patch1,
      patch2    => patch2,
      patch3    => patch3,
      patch4    => patch4,
      trig_prim => trig_prim,
      miso      => miso,
      rx        => rx,
      enables   => enables,
      clr       => clr,
      cs_ld     => cs_ld,
      sck       => sck,
      mosi      => mosi,
      tx        => tx
    );

  -- Clock process definitions
  ext_clk_proc: process
  begin
    ext_clk <= '0';
    wait for ext_clk_period/2;
    ext_clk <= '1';
    wait for ext_clk_period/2;
  end process ext_clk_proc;
 
  -- Stimulus process
  stim_proc: process
  begin		
    -- hold reset state for 100ms.
    wait for 100ms;	
    
    wait for ext_clk_period*10;

    -- insert stimulus here 

    wait;
  end process stim_proc;

end;
