/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Oscar Blanch 11/2002 <mailto:blanch@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// MGeomPMT
//
// This is the base class of the PMT characteristics. 
//
///////////////////////////////////////////////////////////////////////

#include "MLog.h"
#include "MLogManip.h"

#include "MGeomPMT.h"

ClassImp(MGeomPMT);

// --------------------------------------------------------------------------
//
// Initializes a Mirror geometry with 0 values, except for fMirrorID.
//
MGeomPMT::MGeomPMT(Int_t pmt, const char *name=NULL, const char *title=NULL)
{
    fName  = name  ? name  : "MGeomPMT";
    fTitle = title ? title : "Storage container for  a PMT characteristics";

    fPMTId = pmt;
    fWavelength->Set(0);
    fQE->Set(0);

}

void MGeomPMT::SetPMTContent(Int_t pmt, TArrayF *wav, TArrayF *qe)
{
    fPMTId = pmt;

  if(fWavelength->GetSize()==wav->GetSize() &&
     fQE->GetSize()==qe->GetSize()){
    wav->Copy(*fWavelength);
    qe->Copy(*fQE);
  }
  else
     *fLog<<err << "MGeomPMT::SetPMTContent fWavelength "
	  <<"and fQE do not have "
	  <<"size of setting arrays"<<endl;

}





