/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Oscar Blanch  11/2002 (blanch@ifae.es)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MMcConfigRunHeader
//
// Root storage container for the MONTE CARLO CONFIGURATION information
//
// It saves in a root file all the infromation about values in the configuration
// files used in the Monte Carlo production: MagicDef (definition of the teslescope),
// Reflectivity.dat (mirror reflectivities), qe.dat (PMT QEs), axisdev.dat (mirrors 
// deviations) and lightguides.dat (Effect of the Light Guides).
//
////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MMcConfigRunHeader
#include "MMcConfigRunHeader.h"
#endif

#include <fstream.h>
#include <iomanip.h>

#include "MLog.h"
#include "MLogManip.h"
ClassImp(MMcConfigRunHeader);

// --------------------------------------------------------------------------
//
// Default constructor.
//
//
MMcConfigRunHeader::MMcConfigRunHeader(const char *name, const char *title)
{
    fName  = name  ? name  : "MMcConfigRunHeader";
    fTitle = title ? title : "Mc Configuration Information";

    fNumMirrors=0;
    fNumPMTs=0;

    fRadiusMirror=-10.0;
    fFocalDist=-10.0;
    fFocalStdev=-10.0;
    fPointSpread=-10.0;
    fPointStdev=-10.0;
    fDevAdjust=-10.0;
    fBlackSpot=-10.0;
    fCameraWidth=-10.0;

    fIncidentTheta->Set(181);
    fLightGuidesFactor->Set(181);

    fMirrors = new TClonesArray("MGeomMirror", 0);
    fPMTs = new TClonesArray("MGeomPMT", 0);

}

// -------------------------------------------------------------------------
//
// SetMagicDef
//
void MMcConfigRunHeader::SetMagicDef(const Float_t  radius,
				     const Float_t  focal,
				     const Float_t  stdfocal,
				     const Float_t  point,
				     const Float_t  stdpoint,
				     const Float_t  adjust,
				     const Float_t  spot,
				     const Float_t  camwidth)
{
    fRadiusMirror=radius;
    fFocalDist=focal;
    fFocalStdev=stdfocal;
    fPointSpread=point;
    fPointStdev=stdpoint;
    fDevAdjust=adjust;
    fBlackSpot=spot;
    fCameraWidth=camwidth;
    
}

void  MMcConfigRunHeader::SetLightGuides(TArrayF *theta, TArrayF *factor){
  
  if(fIncidentTheta->GetSize()==theta->GetSize() &&
     fLightGuidesFactor->GetSize()==factor->GetSize()){
    theta->Copy(*fIncidentTheta);
    factor->Copy(*fLightGuidesFactor);
  }
  else
    *fLog<<err << "MMcConfigRunHeader::SetLightGuides: fIncidentTheta "
	<<"and fLightGuidesFactor do not have "
	<<"size of setting arrays"<<endl;

}



