#ifndef MARS_MMcCorsikaRunHeader
#define MARS_MMcCorsikaRunHeader
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MMcCorsikaRunHeader                                               //
//                                                                   //
///////////////////////////////////////////////////////////////////////
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif


class MMcCorsikaRunHeader : public MParContainer
{
private:
    // Header copied directly from CORSIKA header, skiping dummy values.
    // The propouse of this container is being able to cmopare with
    // Corsika run Header
    // See CORSIKA manual for explanations
    Float_t fRunNumber;
    Float_t fDate;
    Float_t fCorsikaVersion;
    Float_t fNumObsLev;
    Float_t fHeightLev[10];
    Float_t fSlopeSpec;  // Slope of primaries' energy spectrum
    Float_t fELowLim;
    Float_t fEUppLim;    // Limits of energy range for generation
    Float_t fEGS4flag;
    Float_t fNKGflag;
    Float_t fEcutoffh;
    Float_t fEcutoffm;
    Float_t fEcutoffe;
    Float_t fEcutoffg;

    // Physical constants and interaction flags (see CORSIKA manual):
    Float_t fC[50];
    Float_t fCKA[40];
    Float_t fCETA[5];
    Float_t fCSTRBA[11];
    Float_t fAATM[5];
    Float_t fBATM[5];
    Float_t fCATM[5];
    Float_t fNFL[4];

public:
    MMcCorsikaRunHeader(const char *name=NULL, const char *title=NULL);

    void Fill(const Float_t  runnumber,
              const Float_t  date,
              const Float_t  vers,
              const Float_t  fNumObsLev,
              const Float_t  height[10],
              const Float_t  slope,
              const Float_t  elow,
              const Float_t  eupp,
              const Float_t  egs4,
              const Float_t  nkg,
              const Float_t  eh,
              const Float_t  em,
              const Float_t  ee,
              const Float_t  eg,
              const Float_t  c[50],
              const Float_t  cka[40],
              const Float_t  ceta[5],
              const Float_t  cstrba[11],
              const Float_t  aatm[5],
              const Float_t  batm[5],
              const Float_t  catm[5],
              const Float_t  nfl[4]
             );

    ClassDef(MMcCorsikaRunHeader, 1)	// storage container for general info
};
#endif


