#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <errno.h>
#include <vector>
#include <exception>
#include <cxxabi.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define STATUS_SIZE 1000					// Bytes for status service string
#define EVIDENCE_REVISION "$Revision: 165 $"

// Class declation of Evidence server
class EvidenceServer: public DimServer {

  private:
	struct ConfigItem {
	  char *Name;
	  char *Value;
	  int Time;
	};
	std::vector<struct ConfigItem> ConfigList;

    DimService *Status;
	char *InitMsg;

    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();
	
	enum StateType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void State(StateType, const char *, ...);
	char* GetConfig(const char *, const char * = NULL);
	static char* ToString(DimInfo *);
	static bool ServiceOK(DimInfo *);

    bool ExitRequest;
};

class EvidenceHistory: public DimClient {

  static const int WrapMark[];
  static const int EndMark[];

  std::string HistoryName;
  char *Buffer;
  int BufferSize;
  int Offset;
    
  public:
	EvidenceHistory();
	~EvidenceHistory();
	
	bool GetHistory(char *);
	bool Next(int &, int &, void *&);
};
#endif
