#ifndef MARS_MF
#define MARS_MF

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MF                                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class TMethodCall;

class MF : public MFilter
{
private:
    static const TString gsDefName;  //!
    static const TString gsDefTitle; //!

    MFilter *fFilter; // Filter

    Int_t IsAlNum(TString txt) const;

    MFilter *ParseRule(TString &txt, MFilter *filter0) const;
    MFilter *ParseString(TString txt, Int_t level);

    void StreamPrimitive(ofstream &out) const;

public:
    MF();
    MF(const char *text, const char *name=NULL, const char *title=NULL);
    ~MF();

    Bool_t IsExpressionTrue() const;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MF, 0) // A Filter for cuts in any data member
};

#endif
