#ifndef MARS_MHTimeDiffTheta
#define MARS_MHTimeDiffTheta

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;
class MMcEvt;

class MParList;

class MHTimeDiffTheta : public MH
{
private:
    MTime  *fTime;   //!
    MMcEvt *fMcEvt;  //!
    Double_t fLastTime;

    TH2D    fHist;

public:
    MHTimeDiffTheta(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHTimeDiffTheta, 0) //2D-histogram  time-diff vs. Theta
};

#endif

