function handleFeedbackConnected(wait_state)
{
    var state = dim.state("FEEDBACK");
    if (state===undefined)
        return undefined;

    if (wait_state && wait_state.length>0 && state.name!=wait_state)
        return wait_state;

    //dim.log("FEEDBACK:  "+state.name+"["+state.index+"]");

    switch (state.name)
    {
    case "Disconnected":
    case "Connecting":
    case "ConnectedFSC":
    case "ConnectedFAD":
        return undefined;

    case "Connected":
        return "";

    case "FeedbackIdle":
    case "TempCtrlIdle":
    case "CurrentCtrlIdle":
    case "FeedbackControl":
    case "TempControl":
    case "CurrentControl":
    case "Calibrating":
        console.out("Feedback in '"+state.name+"'... sending STOP... waiting for 'Connected'.");
        dim.send("FEEDBACK/STOP");
        return "Connected";
    }

    throw new Error("FEEDBACK:"+state.name+"["+state.index+"] unknown or not handled.");
}

