#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include <QtGui>
 
#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_scale_engine.h>
#include <qwt_analog_clock.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_legend.h>
#include <qwt_legend_item.h>
#include <qwt_symbol.h>

#include <limits.h>
#include <float.h>

#include "dic.hxx"
#include "Evidence.h"

#define SVN_REVISION "$Revision: 167 $"

QWidget *OpenHistory(char *);

// Time scale for axis
class TimeScale: public QwtScaleDraw {
  public:
    TimeScale() { }
    virtual QwtText label(double v) const {
      QDateTime t = QDateTime::fromTime_t((int) v);
      return t.toString("dMMM'\n'h:m:s");
    }
};

		  
// General indicator for DIM service
class Edd_Indicator: public QLineEdit, public DimClient {
    Q_OBJECT

    QMenu *Menu;
    QPoint dragStart;
    //QwtPlot *LastPlot;
    QWidget *LastPlot;
	
    DimStampedInfo *Data;
	
    void mousePressEvent(QMouseEvent *); 
    void mouseReleaseEvent(QMouseEvent *); 
    void mouseMoveEvent(QMouseEvent *); 
	
  public:
    Edd_Indicator(QString, QWidget * = NULL);
    ~Edd_Indicator();

	bool ShowAsTime;
	
  private slots:
	void Update(DimInfo *, int, QByteArray, QString);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuOpenHistory();
    void MenuCopyService();
    void MenuCopyData();
};

// Graph class for history display
class Edd_Plot: public QwtPlot, public EvidenceHistory {
    Q_OBJECT

    struct PlotItem {
      DimInfo *LiveData;
      QwtPlotCurve *Signal;
      double Smallest;
      double Largest;
	  int SizeLimit;
	  QVector<double> x;
	  QVector<double> y;	  
    };

    QList<struct PlotItem> Items;
    QMutex Mutex;
    
	QString StatusTip;
	
    QMenu *Menu;
    QAction *YLogAction;
    QAction *NormAction;
    QAction *StyleAction;
    
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotZoomer *Zoomer;
    QwtLegend *Legend;
    
    void dragEnterEvent(QDragEnterEvent *);
    void dropEvent(QDropEvent *);

  public:
    Edd_Plot(QString = QString(), QWidget * = NULL);
    ~Edd_Plot();
    void AddService(QString);

  private slots:
    void UpdatePlot();
	void Update(DimInfo* Info, int, QByteArray, QString);

    void HandleZoom(const QwtDoubleRect &);
    void contextMenuEvent(QContextMenuEvent *);
	void LegendClicked(QwtPlotItem *);
    void MenuZoomOut();
    void MenuSingleTrace();        
    void MenuSaveASCII();
    void MenuSave();
    void MenuPrint();
    void MenuPasteService();
};

// Text history class
class Edd_TextHist: public QTextEdit, public EvidenceHistory {
    Q_OBJECT

	QString StatusTip;
	DimStampedInfo *Service;
	
  public:
    Edd_TextHist(QString, QWidget * = NULL);
    ~Edd_TextHist();

  private slots:
	void Update(DimInfo* Info, int, QByteArray, QString);
};

// Textout indicator for DIM service
class Edd_Textout: public QTextEdit, public EvidenceHistory {
    Q_OBJECT

    DimStampedInfo *Data;

  public:
    Edd_Textout(QString, QWidget * = NULL);
    ~Edd_Textout();
	
	bool Accumulate;
	
  private slots:
	void Update(DimInfo* Info, int, QByteArray, QString);
};

// Main window class
class GUI: public QMainWindow, public DimBrowser, public DimInfo {
    Q_OBJECT

    QwtAnalogClock *Clock;
	
    QWidget *Central, *MainWidget, *BiasWidget, *FeedbackWidget, *EnvironmentWidget;
    QGridLayout *MainLayout, *BiasLayout, *FeedbackLayout, *EnvironmentLayout;

    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *);
	void infoHandler();
	
  public:
    GUI();
    ~GUI();
    
  private slots:
    void MenuAbout();
    void MenuNewHistory();
	void StartDIMBrowser();
	
  signals:
    void YEP(DimInfo *, int, QByteArray = QByteArray(), QString = QString());
};

#endif
