#ifndef MGSKYPOSITION_H
#define MGSKYPOSITION_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)


#ifndef MGEMBEDDEDCANVAS_H
#include "MGEmbeddedCanvas.h"
#endif

class TArc;
class TLine;

class ZdAz;
class RaDec;
class TText;
class SlaStars;
class SlaPlanets;

class MGSkyPosition : public MGEmbeddedCanvas
{
    TArc       *fMoon;
    TArc       *fJupiter;
    TArc       *fVenus;
    TArc       *fMars;
    TArc       *fSun;

    TArc       *fDot[6];

    TLine      *fLin1a;
    TLine      *fLin1b;
    TLine      *fLin2;

    TLine      *fSunL[4];

    TText      *fText;

    SlaStars   *fSlaStar;
    SlaPlanets *fSlaPlanet;

    Int_t fX[9];
    Int_t fY[9];

    void InitArc(TArc *arc, Int_t fillstyle, Int_t fillcolor, Int_t linecolor);

    void InitText();
    void InitPlanets();
    void InitPosition();
    void DrawCoordinateSystem();

    void SetLin1(Float_t x, Float_t y);
    void SetLin2(Float_t x1, Float_t y1, Float_t x2, Float_t y2);

    void SetDot(TArc *arc, RaDec &radec, Int_t off);

    void UpdateText(Float_t zd, Float_t az);
    void UpdatePlanet(Int_t planet, TArc *arc);
    void UpdatePosition(RaDec &radec, Float_t zd, Float_t az);

public:
    MGSkyPosition(const TGWindow* p, const UInt_t w);
    ~MGSkyPosition();

    void Update(ZdAz &pos, double mjd);

    ClassDef(MGSkyPosition, 0)
};

#endif // MGSKYPOSITION_H
