//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGVelocity.h"

#include <iostream.h>  // cout

#include <TArc.h>
#include <TWbox.h>
#include <TLine.h>
#include <TText.h>
#include <TList.h>
#include <TGaxis.h>
#include <TArrow.h>
#include <TCanvas.h>

#include "coord.h"

ClassImp(MGVelocity);

void MGVelocity::DrawCoordinateSystem()
{
    /*
    TArc arc;
    arc.SetFillStyle(4000);  // transparent
    arc.SetFillColor(39);
    arc.SetLineColor(3);     // green
    arc.SetLineStyle(2);     // dashed  (s. TAttLine)
    arc.DrawArc(0, 0,  20);

    arc.SetLineColor(5);     // yellow
    arc.DrawArc(0, 0,  40);

    arc.SetLineColor(2);     // red
    arc.DrawArc(0, 0, 60);
    */
    //
    // FIXME? Use TAxis?
    //
/*
    TLine line;
    line.SetLineColor(13);
    line.SetLineStyle(3);  // dotted  (s. TAttLine)
    line.DrawLine(-30., -65., -30.,  65.);
    line.DrawLine(-65., -30.,  65., -30.);
    line.DrawLine( 30., -65.,  30.,  65.);
    line.DrawLine( -6.,  30.,  65.,  30.);

    line.DrawLine(-15., -65., -15.,  65.);
    line.DrawLine(-65., -15.,  65., -15.);
    line.DrawLine( 15., -65.,  15.,  65.);
    line.DrawLine(-65.,  15.,  65.,  15.);

    line.DrawLine(-45., -65., -45.,  65.);
    line.DrawLine(-65., -45.,  65., -45.);
    line.DrawLine( 45., -65.,  45.,  65.);
    line.DrawLine(-65.,  45.,  65.,  45.);

    line.SetLineColor(12);
    line.SetLineStyle(2);  // dashed  (s. TAttLine)
    line.DrawLine(-60., -65., -60.,  65.);
    line.DrawLine(-65., -60.,  65., -60.);
    line.DrawLine( 60., -65.,  60.,  65.);
    line.DrawLine(-65.,  60.,  65.,  60.);

    line.SetLineColor(1);  // black
    line.SetLineStyle(1);  // solid  (s. TAttLine)
    line.DrawLine(-65.,   0, 65.,  0);
    line.DrawLine(  0, -65.,  0, 65.);

    line.DrawLine(-1.,  60., 1.,  60.);
    line.DrawLine(-1., -60., 1., -60.);
    line.DrawLine(-1.,  30., 1.,  30.);
    line.DrawLine(-1., -30., 1., -30.);

    line.DrawLine( 60., -1.,  60., 1.);
    line.DrawLine(-60., -1., -60., 1.);
    line.DrawLine( 30., -1.,  30., 1.);
    line.DrawLine(-30., -1., -30., 1.);

    TText text;
    text.SetTextAlign(22);  // centered, centered (s.TAttText)
    text.DrawText(60., 5., "vAz['/min]");
    text.DrawText(0,  70., "vZd['/min]");

    text.SetTextAlign(23);  // centered, centered (s.TAttText)
    text.DrawText(-60., -2., "-1'");
    text.DrawText( 60., -2., "1'");
    text.DrawText(-30., -2., "-.5'");
    text.DrawText( 30., -2., ".5'");

    text.SetTextAlign(32);  // centered, centered (s.TAttText)
    text.DrawText(-2., -60., "-1'");
    text.DrawText(-2.,  60., "1'");
    text.DrawText(-2., -30., "-.5'");
    text.DrawText(-2.,  30., ".5'");
    */
    TWbox box;
    box.DrawWbox(-145, 145, -35, 120,  18,  2, 1);

    TText text;
    text.SetTextAlign(22);  // centered, centered (s.TAttText)
    text.DrawText(-90., 132.5, fCanvas->GetName());


    TLine line;
    line.DrawLine(-65*2,     0, 65*2,    0);
    line.DrawLine(    0, -65*2,    0, 65*2);

    //
    // Can be replaced by TGaxis axe; in a later root version
    // than 3.01/06. I talked to Rene
    //
    TGaxis *axe;
    axe = new TGaxis(-60*2, 0, 60*2, 0,  -2, 2,  304, "+-N");
    axe->SetTitle("Az"); // \xb0
    axe->SetBit(kCanDelete);
    axe->Draw();

    axe = new TGaxis(0, -60*2, 0, 60*2,  -2, 2,  304, "+-N");
    axe->SetTitle("Zd"); // \xb0
    axe->SetBit(kCanDelete);
    axe->Draw();
}

void MGVelocity::InitVelocity()
{
    /*
     fLin1  = new TLine(0, 0, 0, 0);
    fLin2  = new TLine(0, 0, 0, 0);

    fLin1->SetLineColor(10); // white (s. TAttFill)
    fLin2->SetLineColor(10); // white
    fLin1->SetLineStyle(1);  // solid (s. TAttLine)
    fLin2->SetLineStyle(1); 

    fLin1->Draw();
    fLin2->Draw();

    fList->Add(fLin1);
    fList->Add(fLin2);
    */
    fArrow    = new TArrow(0, 0, 0, 0, 0.01);
    fArrowX   = new TArrow(0, 0, 0, 0, 0.01);
    fArrowY   = new TArrow(0, 0, 0, 0, 0.01);
    fArrowAvg = new TArrow(0, 0, 0, 0, 0.01);

    fArrow->SetLineColor(10);   // white
    fArrowX->SetLineColor(17);  // light gray
    fArrowY->SetLineColor(17);  // light gray
    fArrowAvg->SetLineColor(137);  // light gray

    fArrow->Draw();
    fArrowX->Draw();
    fArrowY->Draw();
    fArrowAvg->Draw();

    fList->Add(fArrow);
    fList->Add(fArrowX);
    fList->Add(fArrowY);
    fList->Add(fArrowAvg);

    fText = new TText(70*2, -70*2, "x1");
    fText->SetTextColor(10);
    fText->SetTextAlign(31); // right, bottom
    fText->Draw();
    fList->Add(fText);

    fTextVel = new TText(2*70, 2*70, "");
    fTextVel->SetTextAlign(33);  // right, top
    fTextVel->SetTextColor(10);  // white
    fTextVel->Draw();
    fList->Add(fTextVel);
}

MGVelocity::MGVelocity(const TGWindow* p, const char *name, const UInt_t w)
: MGEmbeddedCanvas(name, p, w, 75*2), fPos(-1), fScale(1)
{
    fOld = new XY;
    fAvg = new XY[10];

    DrawCoordinateSystem();
    InitVelocity();

    InitCanvas();
}

MGVelocity::~MGVelocity()
{
    delete fOld;
    delete fAvg;

    //    cout << "MGVelocity destroyed." << endl;
}

void MGVelocity::UpdateText()
{
    char txt[10];

    if (fScale>1)
        sprintf(txt,  "/%.0f", fScale);
    else
        sprintf(txt,  "x%.0f", 1./fScale);

    fText->SetText(fText->GetX(), fText->GetY(), txt);
}

Bool_t MGVelocity::UpdateAvg(const float x, const float y)
{

    //
    // calculate scale factor from avarage over
    // speed, not pixels
    //
    // different scales for Az and Zd
    //
    // check for the number of the value
    //
    //
    const int num = 10;

    //    static int pos = -1;
    //    static XY avg[num];

    if (fPos<0)
        for (int i=1; i<num; i++)
            fAvg[i].Set(x, y);

    fPos++;
    fPos %= num;

    fAvg[fPos].Set(x, y);

    Float_t avgx = 0;
    Float_t avgy = 0;

    for (int i=0; i<num; i++)
    {
        avgx += fAvg[i].X();
        avgy += fAvg[i].Y();
    }

    avgx /= 10.;
    avgy /= 10.;

    avgx *= fScale;
    avgy *= fScale;

    fArrowAvg->SetX2(avgx);
    fArrowAvg->SetY2(avgy);

    //    cout << avgx << " " << avgy << endl;

    if ((fabs(avgx)>/*40.*/110. || fabs(avgy)>/*40.*/110.))
    {
        fScale /= 2;
        return kTRUE;
    }

    if ((fabs(avgx)< 5. && fabs(avgy)<20.) ||
        (fabs(avgx)<20. && fabs(avgy)< 5.))
    {
        fScale *= 2;
        return kTRUE;
    }

    return kFALSE;
}

void MGVelocity::UpdateVelText(Float_t vx, Float_t vy)
{
    static int X = ~0;
    static int Y = ~0;

    vx /= 60.;  //['/min]
    vy /= 60.;  //['/min]

    int fx = (int)/*floor*/(vx*10.);
    int fy = (int)/*floor*/(vy*10.);

    if (X==fx && Y==fy)
        return;

    X = fx;
    Y = fy;

    char txt[100];
    sprintf(txt, "Zd=%.1f'\nAz=%.1f'",
            vy, vx);

    fTextVel->SetText(fTextVel->GetX(), fTextVel->GetY(), txt);
}

void MGVelocity::Update(ZdAz &zdaz)
{
    //
    // calculate actual time for planet positions
    //
    //    static int X = 0xaffe;
    //    static int Y = 0xaffe;

    float vx = zdaz.Az()*3600.; // ["/min]
    float vy = zdaz.Zd()*3600.; // ["/min]

    UpdateVelText(vx, vy);

    int pixx = (int)(vx*fScale/fPix);
    int pixy = (int)(vy*fScale/fPix);

    //
    // FIXME! Check for the right place!
    //
    Bool_t rc = kFALSE;

    if (pixx || pixy)
        rc = UpdateAvg(vx, vy);

    if (rc)
        UpdateText();

    if (!rc && (int)fOld->X()==pixx && (int)fOld->Y()==pixy)
        return;

    //    cout << fScale << ": " << pixx << " " << pixy;
    //    cout << fScale << ": " << (int)rc << (int)((int)fOld->X()==pixx) << (int)((int)fOld->Y()==pixy) << "  ";
    //    cout << zdaz.Az()*3600. << " " << zdaz.Zd()*3600. << endl;

    vx *= fScale;
    vy *= fScale;

    fArrow->SetX2(vx);
    fArrow->SetY2(vy);

    fArrowX->SetX2(vx);
    fArrowY->SetY2(vy);

    fOld->Set(pixx, pixy);

    SetModified();
    UpdateCanvas();
}
