function GetData() 
{
	var source = new Array();
	//calls the xml request in a loop based on the current sources                
	$('#box2View option').each(function()
	{
		 source.push($(this).text());
		 
	});
	console.log(source);
	for (i = 0; i<source.length; i++) 
	{
		GetXMLData(i, source);
	}
}
function GetXMLData(index, source) 
{
	var XML;
	XML = new XMLHttpRequest();
	//NOTE: previous errors on the request was caused by appending "http://www.fact-project.org"
	XML.open("GET","/smartfact/index.php?source="+rawurlencode(source[index])+"&time="+year+"-"+month+"-"+day,true);
	dataSource = new Array();
	XML.onload=function() 
	{
		if (XML.status==200)
		{
			line=XML.responseText.split('\n');
			dataSource.push(line);
			if (dataSource.length == source.length)
				{
				displayXMLData(dataSource, source); //this will be called when the last data from the list is read
				}
		}
		else
			alert("status is " + XML.status);
	};
	
	XML.send();
}

function displayXMLData(dataSource, source)
{
	var options = 
	{
			chart: {
				renderTo: 'Graph' /* display to div Graph*/
				
			},
			
			xAxis: {
				categories:[]
			},
			series:[], /* array of Data  */
			
			remove:function()
			{
				return false;
			},
			
			 exporting: {							/*--------------------*/
				buttons: {							/*					  */
					exportButton: {					/*		Export		  */
						menuItems: null,			/*		  to		  */
						onclick: function() {		/*			PNG.file  */
							this.exportChart();		/*--------------------*/
						}
					}
				}
			},
			plotOptions : {
			
			series : {
					lineWidth: 3,
			
				marker : {
					enabled:false
				}
			}
		}
	};
	//This function splits the lines of data per data source
	var dataGraph = new Array(source.length);
	var Time = new Array(source.length);
	var HourMin = new Array();
	var chart = new Highcharts.Chart(options);
	for (i=0; i<source.length; i++) 
	{
		dataGraph[i] = new Array(); //dataGraph contains the individual points for each source i
		Time[i] = new Array(); // Time contains the individual time for each sources.
		chart.addSeries({name:source[i], data:[]}); // created a series of data and add name of displayed source	
		
		for(row=0;row<dataSource[i].length;row++)
		{
			rows=dataSource[i][row].split(',');
			dataGraph[i].push(parseFloat(rows[4])||parseFloat('0'));
			dateTime = new Date(rows[0]);
			Time[i].push(parseFloat(dateTime.getHours())+'.'+parseInt(dateTime.getMinutes()/60*100));
			
		}
		for(Graph=0;Graph<dataGraph[i].length;Graph++)
		{						
				chart.series[i].addPoint({ // series[0] means index of zero in data;
				x:Time[i][Graph], // Time
				y:dataGraph[i][Graph] // Value
				})
		}
	}
	
}