//simple test program to check the PixelMap class

#include "../../pixelmap/PixelMap.h"
#include <iostream>

int main(){

    std::cout << std::endl;
    std::cout << "==============================" << std::endl;
    std::cout << "PixelMap Test Program" << std::endl;
    std::cout << "==============================" << std::endl;
    std::cout << std::endl;

    PixelMap* pm = new PixelMap(true);

    pm->Print();

    std::string drs1 = pm->DRS_to_Pixel(0,0,0,true);
    std::cout << "Name: " << drs1 << std::endl;

    std::string drs2 = pm->DRS_to_Pixel(1,0,0,true);
    std::cout << "Name: " << drs2 << std::endl;

    std::string drs3 = pm->DRS_to_Pixel(0,0,0,true);
    std::cout << "Name: " << drs3 << std::endl;

    std::string hv1 = pm->HV_to_Pixel(6,1,8,true);
    std::cout << "Name: " << hv1 << std::endl;

    std::string hv2 = pm->HV_to_Pixel(6,9,1,true);
    std::cout << "Name: " << hv2 << std::endl;

    std::string hv3 = pm->HV_to_Pixel(1,0,0,true);
    std::cout << "Name: " << hv3 << std::endl;

    unsigned int drsb1 = pm->Pixel_to_DRSboard("0-1-1",true);
    std::cout << "Board: " << drsb1 << std::endl;

    unsigned int drsb2 = pm->Pixel_to_DRSboard("1-0-0",true);
    std::cout << "Board: " << drsb2 << std::endl;

    pm->Print();

    std::string drs4 = pm->DRS_to_Pixel(0,0,1,true);
    std::cout << "Name: " << drs4 << std::endl;

    unsigned int hvchain1 = pm->Pixel_to_HVchain("0-1-1",true);
    std::cout << "Chain: " << hvchain1 << std::endl;

    unsigned int hvchain2 = pm->Pixel_to_HVchain("1-0-0",true);
    std::cout << "Chain: " << hvchain2 << std::endl;

    delete pm;

    return 0;

}
