#ifndef PIXELMAP_H
#define PIXELMAP_H

#include "Pixel.h"
#include <map>
#include <string>
#include <map>

class PixelMap {

private:    

public:
    
    PixelMap(bool verbose=false);
    ~PixelMap();
    
    std::map<std::string, Pixel*> pixelmap;

    void ReadPixelMap(std::map<std::string, Pixel*>& pixelmap, bool verbose=false);
    void Print();

    std::string DRS_to_Pixel(unsigned int DRSboard, unsigned int DRSchip, unsigned int DRSchannel, bool verbose=false);
    std::string HV_to_Pixel(unsigned int HVboard, unsigned int HVchain, unsigned int HVchannel, bool verbose=false);
    
    unsigned int Pixel_to_DRSboard(std::string pixelname, bool verbose=false);
    unsigned int Pixel_to_DRSchip(std::string pixelname, bool verbose=false);
    unsigned int Pixel_to_DRSchannel(std::string pixelname, bool verbose=false);

    unsigned int Pixel_to_HVboard(std::string pixelname, bool verbose=false);
    unsigned int Pixel_to_HVchain(std::string pixelname, bool verbose=false);
    unsigned int Pixel_to_HVchannel(std::string pixelname, bool verbose=false);

};

#endif
