#ifndef MGCOSY_H
#define MGCOSY_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class TIterator;

class TGLabel;
class TGPopupMenu;
class TGMenuBar;
class TGHorizontal3DLine;
class TGLayoutHints;
class TGCompositeFrame;
class TGTab;
class TGListBox;

class ZdAz;
class RaDec;
class MsgQueue;

class MGImage;
class MGList;
class MGCoordinates;
class MGSkyPosition;
class MGAccuracy;
class MGVelocity;

class MGCosy : public TGMainFrame
{
private:

    //
    // Create a main frame with a number of different buttons.
    //
    TGLayoutHints *fLayMenuBar;
    TGLayoutHints *fLayMenuItem;

    MGList        *fList;

    TGLabel      **fLabel1;
    TGLabel      **fLabel2;
    TGLabel      **fLabel3;

    TGLabel       *fOffsetZd;
    TGLabel       *fOffsetAz;

    TGLabel       *fRaEst;
    TGLabel       *fDecEst;

    TGLabel       *fRaSoll;
    TGLabel       *fDecSoll;

    TGLabel       *fZdSoll;
    TGLabel       *fAzSoll;

    TGLabel       *fUtc;
    TGLabel       *fMjd;

    MGCoordinates *fCZdAz;
    MGCoordinates *fCRaDec;
    MGCoordinates *fCCalib;

    MGSkyPosition *fSkyPosition;
    MGAccuracy    *fAccuracy;
    MGVelocity    *fVelocity;
    MGVelocity    *fOffset;

    MsgQueue      *fQueue;

    TGTab         *fTab;

    TGLabel *fError;
    TGLabel *fMoving;
    TGLabel *fTracking;
    TGLabel *fStopping;
    TGLabel *fStopped;

    TGListBox *fLog;

    void CreateMenu();
    void CreateLabel(TGCompositeFrame *f);
    void CreateTabs(TGTab *fTab);

    void StartPos();
    void StartTrack();
    void StartDemo();
    void StartCalib();
    void StartTPoint();

    void EnableLabel(TGLabel *label, Bool_t stat);
    void UpdateOffset(ZdAz &off);
    void UpdateZdAz(ZdAz &off);
    void UpdateRaDec(ZdAz &pos, double mjd, RaDec &radec);
    double UpdateTime();

public:
    MGCosy(MsgQueue *q, const TGWindow *p, UInt_t w, UInt_t h);
    ~MGCosy();

    void CloseWindow();

    TGLabel **GetLabel1() const { return fLabel1; }
    TGLabel **GetLabel2() const { return fLabel2; }
    TGLabel **GetLabel3() const { return fLabel3; }

    TGListBox *GetLog() const { return fLog; }

    void Update(ZdAz pos, ZdAz acc, ZdAz vel, ZdAz off, RaDec radec, ZdAz soll, UInt_t stat);

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2);

    ClassDef(MGCosy, 0)
};

#endif


