inpath=$PWD/$1
outpath=${inpath}/fit
macro=${PWD}/fit_spectra.C

mkdir -p $outpath

files_out=`ls -1 ${inpath}  | grep \.root`
files_fit=`ls -1 ${outpath} | grep \.root`

for file in $files_out
do
    infile=$inpath"/"${file}
    outfile=${outpath}"/"${file}
    
    if [ -e $outfile ]
    then 
       continue
    fi

    cmd="${ROOTSYS}/root -b -q -l ${macro}+\(\\\"${infile}\\\",\\\"${outfile}\\\"\)"

    cd ~/Mars

    echo  ${cmd} | qsub -b yes -q test -cwd -e ${outfile}".err" -o ${outfile}".log"

    cd -
done

