#!/bin/bash

threshold=5
maxdist=14
macro=$PWD/extract_singles.C
outpath=$PWD/files

mkdir -p $outpath
cp ${macro} ${outpath}

where="(((fNumPedestalTrigger=3000 OR fNumPedestalTrigger=5000) AND fRunTypeKEY=2) OR (fNumPedestalTrigger=10000 AND fRunTypeKEY=3) OR fRunTypeKEY=17)"
wheredrs="(drs.fROI=single.fROI AND fDrsStep=2)"

query="SELECT Concat(fNight, '_', fRunId, '_', (SELECT fRunId FROM RunInfo \`drs\` WHERE drs.fNight=single.fNight AND "$wheredrs" AND (single.fRunId-drs.fRunId)<30 limit 0,1)) AS num "
query=$query" FROM RunInfo \`single\` WHERE "$where

runpairs=( `mysql -u factread --password=r3adfac! --host=lp-fact factdata -s -e "$query"` )

for runpair in ${runpairs[@]}
do
   if [ $runpair = 'NULL' ]
   then
      continue
   fi

   year=`echo $runpair | cut -c1-4`
   month=`echo $runpair | cut -c5-6`
   day=`echo $runpair | cut -c7-8`
   night=`echo $runpair | cut -d_ -f1`
   run=`echo $runpair | cut -d_ -f2`
   drs=`echo $runpair | cut -d_ -f3`
   name=`echo $night | cut -c3-`

   runnum=`printf %03d $run`
   drsnum=`printf %03d $drs`

   path="/fact/raw/"$year"/"$month"/"$day
   runfile=$path"/"$night"_"
   drsfile=$path"/"$night"_"$drsnum.drs.fits.gz
   log=$outpath"/"$night"_"$runnum

   outfile=$outpath/`basename $runfile`${runnum}_${runnum}.root

   if [ -e $outfile ]
   then
      continue
   fi

#  echo "Submitting "${night}"_"${runnum}"["${drsnum}"]"

   cd ~/Mars

   cmd="ROOT_HIST=0 ${ROOTSYS}/bin/root -q -b -l ${macro}+\($maxdist,$threshold,\\\"$runfile\\\",$run,$run,\\\"$drsfile\\\",\\\"${outpath}\\\"\)"

   echo "echo '${cmd}'; date; ${cmd}" | qsub -N e${name}${runnum} -q test -cwd -e ${log}".err" -o ${log}".log"

   cd - > /dev/null
done


