#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include <QtGui>
 
#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_scale_engine.h>
#include <qwt_analog_clock.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_legend.h>
#include <qwt_legend_item.h>
#include <qwt_symbol.h>

#include <limits.h>
#include <float.h>

#include "dic.hxx"
#include "Evidence.h"

#define SVN_REVISION "$Revision: 174 $"

QWidget *OpenHistory(char *, int);

// Time scale for axis
class TimeScale: public QwtScaleDraw {
  public:
    TimeScale() { }
    virtual QwtText label(double v) const {
      QDateTime t = QDateTime::fromTime_t((int) v);
      return t.toString("dMMM'\n'hh:mm:ss");
    }
};

		  
// General indicator for DIM service
class EddLineDisplay: public QLineEdit {
    Q_OBJECT

    QMenu *Menu;
    QPoint dragStart;
    QWidget *LastPlot;
	
	QString ServiceName;
	int Index;
	
    void mousePressEvent(QMouseEvent *); 
    void mouseReleaseEvent(QMouseEvent *); 
    void mouseMoveEvent(QMouseEvent *); 
	
  public:
    EddLineDisplay(QString, int=0, QWidget * = NULL);
    ~EddLineDisplay();

	bool ShowAsTime;
	
  private slots:
	void Update(QString, int, QByteArray, QString, QString);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuOpenHistory();
    void MenuCopyService();
    void MenuCopyData();
};

// Graph class for history display
class EddPlot: public QwtPlot {
    Q_OBJECT

    struct PlotItem {
      QString Name;
      QwtPlotCurve *Signal;
      double Smallest;
      double Largest;
	  int SizeLimit;
	  QVector<double> x;
	  QVector<double> y;
	  int Index;	  
    };

    QList<struct PlotItem> Items;
    QMutex *Mutex;
    
    QMenu *Menu;
    QAction *YLogAction;
    QAction *NormAction;
    QAction *StyleAction;
    
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotZoomer *Zoomer;
    QwtLegend *Legend;
    
    void dragEnterEvent(QDragEnterEvent *);
    void dropEvent(QDropEvent *);

  public:
    EddPlot(QString = QString(), int = 0, QWidget * = NULL);
    ~EddPlot();
    void AddService(QString, int = 0);

  private slots:
	void Update(QString, int, QByteArray, QString, QString);
    void UpdatePlot();

    void HandleZoom(const QwtDoubleRect &);
    void contextMenuEvent(QContextMenuEvent *);
	void LegendClicked(QwtPlotItem *);
    void MenuZoomOut();
    void MenuSingleTrace();        
    void MenuSaveASCII();
    void MenuSave();
    void MenuPrint();
    void MenuPasteService();
};

// Text history and output class
class EddText: public QTextEdit {
    Q_OBJECT

	QString Name;
	bool Pure;
	
  public:
    EddText(QString, bool = false, QWidget * = NULL);
    ~EddText();

	bool Accumulate;

  private slots:
	void Update(QString, int, QByteArray, QString, QString);
};

// Interface to DIM system
class EddDim: public QObject, public DimInfo {
    Q_OBJECT

	struct Item {
	  QString Name;
	  DimStampedInfo *DIMService;
	  int Count;
	  int TimeStamp;
	  QByteArray ByteArray;
	  QString Format;
	  QString Text;
	};
    QList<Item> ServiceList;
    QMutex *Mutex;

	struct HistItem {
	  QString Name;
	  int Count;
	  class EvidenceHistory *HistClass;
	};
    QList<HistItem> HistoryList;

	long long TotalVolume;
	long long MinuteVolume;

	void infoHandler();

  private slots:
	void Update(QString, int, QByteArray, QString, QString);
	void UpdateStatistics();

  public:
    EddDim();
    ~EddDim();

	void Subscribe(QString);
	void Unsubscribe (QString);
	class EvidenceHistory *GetHistory(QString);

  signals:
    void YEP(QString, int, QByteArray = QByteArray(), QString = QString(), QString = QString());
};


// Main window class
class GUI: public QMainWindow, public DimBrowser {
    Q_OBJECT

    QwtAnalogClock *Clock;
	
    QWidget *Central, *MainWidget, *BiasWidget, *FeedbackWidget, *FeedbackDetailsWidget, *EnvironmentWidget;
    QGridLayout *MainLayout, *BiasLayout, *FeedbackLayout, *FeedbackDetailsLayout, *EnvironmentLayout;

    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *);
	
  public:
    GUI();
    ~GUI();
    
  private slots:
    void MenuAbout();
    void MenuNewHistory();
	void StartDIMBrowser();
	void FeedbackDetails();
};

#endif
