/*###########################################################################
  #
  #  This file is part of MTrigLvl2 simulation toolkit for simulating the 
  #  MAGIC Second Level Trigger	
  #                                           e-mail:  stamerra@pi.infn.it 
  #                                                    marcos@gae.ucm.es    #
  #                                             date:  January 2003         #
  #                                          version:  0.1                  #
  ###########################################################################*/


#include "MParContainer.h"

class MMcTrig;
class MGeomCamMagic;
class MCamDisplay;


class MTrigLvl2 : public MParContainer
{

 private:
  Int_t fPixels[36][19];  // Array with the triggered pixels after Lvl1
                          // First index:  pixels index in trigger cell       
                          // Second index: trigger cell number  
  MMcTrig *fMcTrig;
  MGeomCamMagic *fGeomcam;  
  MCamDisplay *fCam;

   
 public: 
  MTrigLvl2(const char* name = NULL, const char* title = NULL);
  
  
  void DrawCell(Int_t cell);  
  void DrawLv1();

  void PrintCell(Int_t cell);
  void PrintStatus();

  void SetLv1(MMcTrig *trig); 
  void SetPixelFired(Int_t pixle, Int_t fired);
 
  Int_t GetCellNumberFired(int cell);
  Int_t GetBiggerFiredCell();
  
  ClassDef(MTrigLvl2,0)
};


