
#include "MTrigLvl2FillTask.h"
#include "MTrigLvl2.h"


#include "MParList.h"
#include "MLog.h"
#include "MLogManip.h"

#include "MMcEvt.hxx"
#include "MMcTrig.hxx"
#include "MMcRunHeader.hxx"

#include <TH1.h>
#include <stdio.h>
#include <iostream.h>

ClassImp(MTrigLvl2FillTask);


/******************************************************************************
 * Default constructor
 *
 *****************************************************************************/
MTrigLvl2FillTask::MTrigLvl2FillTask(const char *name, const char *title)
{
  fName  = name  ? name  : "MTrigLvl2FillTask";
  fTitle = title ? title : "Task to Fill the MTrigLvl2 object";
  
  AddToBranchList("MMcEvt.fEnergy");
  AddToBranchList("MMcEvt.fImpact"); 
  AddToBranchList(Form("%s.fNumFirstLevel", "MMcTrig"));
  AddToBranchList(Form("%s.fPixelsFirst[73][4]", "MMcTrig"));


  h1 = new TH1F("h1","h1",30,0,30);
} 


/******************************************************************************
 * PreProcess
 *
 *****************************************************************************/
Bool_t MTrigLvl2FillTask::PreProcess (MParList *pList)
{
    // connect the raw data with this task

    fMcEvt = (MMcEvt*)pList->FindObject("MMcEvt");
    if (!fMcEvt)
    {
        *fLog << err << dbginf << "MMcEvt not found... exit." << endl;
        return kFALSE;
    }

    fMcTrig = (MMcTrig*)pList->FindObject("MMcTrig");
    if (!fMcTrig)
    {
        *fLog << err << dbginf << "MMcTrig not found... exit." << endl;
        return kFALSE;
    }

    fMTrigLvl2 = (MTrigLvl2*)pList->FindObject("MTrigLvl2");
    if (!fMTrigLvl2)
    {
        *fLog << err << dbginf << "MTrigLvl2 not found... exit." << endl;
        return kFALSE;
    }

    return kTRUE;
}




/******************************************************************************
 * Process 
 *
 *****************************************************************************/
Bool_t MTrigLvl2FillTask::Process()
{
  //const Float_t energy = fMcEvt->GetEnergy();

  fMTrigLvl2->SetLv1(fMcTrig);

  //fMTrigLvl2->DrawLv1();
  //fMTrigLvl2->DrawCell(fMTrigLvl2->GetBiggerFiredCell() );
  //fMTrigLvl2->PrintStatus();

  h1->Fill( fMTrigLvl2->GetCellNumberFired(fMTrigLvl2->GetBiggerFiredCell()) );


  return kTRUE;
}



/******************************************************************************
 * PostProcess : Display the histogram
 *
 *****************************************************************************/
Bool_t MTrigLvl2FillTask::PostProcess()
{ 
  
    *fLog << inf << "Filling..." << endl;
 
    h1->Draw();
      
    return kTRUE;
}

