
Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

void triglvl2(char *filename = "../../Mars-0.8/gamma_new.root")
{ 
    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    MTrigLvl2 cell;
      
    parlist.AddToList(&cell);
    parlist.AddToList(&tasklist);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadMarsFile reader("Events", filename);
    reader.EnableBranch("fEnergy");
    reader.EnableBranch("fImpact"); reader.EnableBranch("fTimeFirst[4]");
    reader.EnableBranch("fPixelsFirst[73][4]");
   
   
   
    MTrigLvl2FillTask fill("MTrigLvl2FillTask","MTrigLvl2FillTask");  
  
    tasklist.AddToList(&reader);
      tasklist.AddToList(&fill);


    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    MProgressBar bar;
    magic.SetProgressBar(&bar);


   //  if (!magic.Eventloop())
   //         return;


    if (!magic.PreProcess())
      return;



    while (tasklist.Process())
      {
        cout << "Event #" << reader.GetEventNum() ":" << endl;

	cell.DrawLv1();
      
	//if (!HandleInput())
	 // break;
    } 



    magic.PostProcess();

    tasklist.PrintStatistics();

    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayd
    //
  // parlist.FindObject("MHMcCollectionArea")->DrawClone();
}
