#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <errno.h>
#include <vector>
#include <exception>
#include <cxxabi.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define STATUS_SIZE 1000					// Bytes for status service string
#define EVIDENCE_REVISION "$Revision: 174 $"

// Class declation of Evidence server
class EvidenceServer: public DimServer {
  private:

	// This class will contain in LastModifyTime always
	// the unix time of the last config file update 
	class ConfigUpdate: public DimClient {
	  DimInfo *ModifyInfo;
	  
	  public:
	    ConfigUpdate() {
	      LastModifyTime = 0;
		  ModifyInfo = new DimInfo("Config/ModifyTime", NO_LINK, this);
	    }
		~ConfigUpdate() {
		  delete ModifyInfo;
		}
	    void infoHandler(){
	      if (EvidenceServer::ServiceOK(getInfo())) LastModifyTime = getInfo()->getInt();
	    }
		int LastModifyTime;
	};

	struct ConfigItem {
	  char *Name;
	  char *Value;
	  int Time;
	};
	std::vector<struct ConfigItem> ConfigList;

    DimService *Status;
	class ConfigUpdate *ModifyInfo;
	
	char *InitMsg;
	int LastModifyTime;

    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();

	enum StateType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void State(StateType, const char *, ...);
	char* GetConfig(const char *, const char * = NULL);
	static char* ToString(DimInfo *);
	static bool ServiceOK(DimInfo *);

    bool ExitRequest;
};

class EvidenceHistory: public DimClient {

  static const int WrapMark[];
  static const int EndMark[];

  std::string Name;
  char *Buffer;
  int BufferSize;
  int Offset;
  int Delay;
  int LastUpdate;
  
  public:
	EvidenceHistory(std::string, int = 10);
	~EvidenceHistory();
	
	bool GetHistory();
	bool Next(int &, int &, void *&);
};
#endif
