#include "Slalib.h"

#include <time.h>
#include <iostream.h>  // cout

#include "coord.h"

#include "slalib.h"

ClassImp(Slalib);

Slalib::Slalib() : Timer()
{
    // p = pointer to MainFrame (not owner)

    //
    // calculate observers location (goe)
    //
    int status;
    //slaDaf2r(51, 38, 48.0, &fPhi,   &status);
    //slaDaf2r( 9, 56, 36.0, &fElong, &status);
    //fHeight = 300;

    slaDaf2r(28, 45, 30.0, &fPhi,   &status);
    slaDaf2r(17, 52, 48.0, &fElong, &status);

    fElong *= -1;
    fHeight = 2326;

    cout << "Latitude: 51\x9c 38'48.0\" = " <<  kRad2Deg*fPhi << "   ";
    cout << "Longitude: 9\x9c 56'36.0\" = " <<  kRad2Deg*fElong << endl;
}

Slalib::~Slalib()
{
}

void Slalib::SetMjd(const double mjd)
{
    fMjd   = mjd;
    fAlpha = slaGmst(fMjd) + fElong;
}

void Slalib::SetMjd2Now()
{
    Now();
    SetMjd(CalcMjd());
//    cout << "GetMjd: "<< (*this)() << " " << GetMjd() << endl;
}

void Slalib::SetMjd(const struct timeval *tm)
{
    SetTimer(tm);
    SetMjd(CalcMjd());
}


ZdAz Slalib::XYZ2ZdAz(double coord[3]) const
{
    //
    // -- xyz to spherical coordinates --
    //
    double ra, dec;
    slaDcc2s(coord, &ra, &dec);

    //
    // radec[rad] -> hadec[rad]
    //
    const double ha = fAlpha-ra;

    //
    // hadec[rad] -> altaz[rad]
    //
    double alt, az;
    slaDe2h(ha, dec, fPhi, &az, &alt);

    return ZdAz(kPiDiv2-alt, az);
}