#!/bin/bash
#
# This script checks, if there are WARNs or ERRORs in the processlog of 
# the last night and sends them to the emailadresse(s) in $erradr
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

lasthour=`date +'%F %H' --date="-1hour"`

processlogfile=$processlogpath/process`date +%F --date="-1hour"`.log

if grep -E "^$lasthour.*WARN" $processlogfile >/dev/null
then 
   grep -E "^$lasthour.*WARN" $processlogfile | mail -s 'found warnings in '$processlogfile $erradrs
   printprocesslog "INFO sent warnings to "$erradrs
fi

if grep -E "^$lasthour.*ERROR" $processlogfile >/dev/null
then 
   grep -E "^$lasthour.*ERROR" $processlogfile | mail -s 'found errors in '$processlogfile $erradrs
   printprocesslog "INFO sent errors to "$erradrs
fi

if grep -E "^$lasthour.*CONNECTION" $processlogfile >/dev/null
then 
   grep -E "^$lasthour.*CONNECTION" $processlogfile | mail -s 'found connection problems found ($processlogfile)' $erradrs
   printprocesslog "INFO sent errors to "$erradrs
fi

printprocesslog "INFO finished $0"

