#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

# setup to use ftools
source $HEADAS/headas-init.sh

logfile=$runlogpath"/FillRatescan-"$datetime".log"
date >> $logfile

# this script doesn't need variable $doupdate
# filling is done by macro and update is always done

# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )
#dates=( `find -L $ziprawdata -mindepth 3 -type d | sort -r | sed "s/\${ziprawdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

#dates=( "2013/01/31" )

printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

#echo ${dates[@]}

cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   auxdir=$auxdata/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   
   # check if aux files are available from that night
   if ! [ -d $auxdir ]
   then
      printprocesslog "INFO no data available in "$auxdir
      continue
   else
      printprocesslog "INFO processing files in "$auxdir
   fi
   
   rawdir=$rawdata/$date
   # check if raw files are available from that night
   if ! [ -d $rawdir ]
   then
      logtext="INFO"
   else
      logtext="WARN"
   fi

   ratescanfile=$auxdir/$runnumber.RATE_SCAN_DATA.fits
   printprocesslog "INFO processing "$ratescanfile
   echo "INFO processing "$ratescanfile >> $logfile 2>&1
   if ! [ -e $ratescanfile ]
   then 
      printprocesslog $logtext" "$ratescanfile" not found."
      continue
   else
      ratescannumerrors=`fverify $ratescanfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $ratescannumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $ratescanfile fverify returned "$ratescannumerrors" error(s)."
      fi
   fi

   printprocesslog "INFO run fillratescan.C for night "$runnumber
   echo "run fillratescan.C for night "$runnumber >> $logfile 2>&1
   check1=`root -q -b -l fact/processing/fillratescan.C\("\"$ratescanfile"\"\,kFALSE\) | tee $logfile | intgrep`
   case $check1 in
      1)   printprocesslog "INFO fillratescan.C was successfully for night "$runumber" (check1=$check1)."
           ;;
      0)   printprocesslog "WARN connection to DB failed (check1=$check1)."
           ;;
      *)   printprocesslog "ERROR fillratescan.C failed for night "$runumber" (check1=$check1)."
           ;;
   esac


done

finish


