#ifndef HVFEEDBACK_H_SEEN
#define HVFEEDBACK_H_SEEN

#define BUF_LENGTH 1000

#include <stdlib.h>
#include <math.h>

#define SERVER_NAME "Feedback"       // Name to use in DIM
#include "Evidence.h"

#include "RawDataCTX.h"
#include "DAQReadout.h"

#define kNumberOfChipsMax 2
#define kNumberOfChannelsMax 10

enum FBState {FB_Off, FB_Active, FB_Targets, FB_ResponseFirst, FB_ResponseSecond};

class HVFeedback: public EvidenceServer {

    class DAQReadout *m;
    class PixelMap *PixMap;
    FBState FBMode;
    
    float (*Average)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Sigma)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Response)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Target)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Buffer)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*DIMAverage)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*DIMSigma)[kNumberOfChipsMax][kNumberOfChannelsMax];

	DimService *FeedbackAverage;
	DimService *FeedbackSigma;
	DimService *FeedbackResponse;
	DimService *FeedbackTarget;
	DimService *CountService;

	int NumAverages;	// Events to take before feedback acts
	int Count;		// Number of currently integrated events
    int LastServiceUpdate;

    float Gain;     	    	// Feedback gain
    float DiffVoltage;	    	// for response measurement	
    char TextBuf[BUF_LENGTH];
	
    int fLedTrigBoard;
    int fLedTrigChip;
    int fLedTrigChannel;
    int fLedTrigSample;
    float fLedTrigThreshold;
    int fLedSignalSample;
    int fLedBaselineSample;
    unsigned int fIntHalfWidth;
    int fDefaultNumAverage;

    int fNumberOfChannels;
    int fNumberOfChips;
    
  public:
    HVFeedback(class DAQReadout*, char*);
    ~HVFeedback();

    bool ProcessEvent();
    void SetTarget(int, int, int, float);
    void GetTargets();
    void SetGain(float);
    float GetGain();
    void SetNumAverages(unsigned int);
    unsigned int GetNumAverages();
    void SetFBMode(FBState, bool=false);
    FBState GetFBMode();
    unsigned int GetCurrentCount();
    void MeasureResponse(float);
    void GetResponse();
    void ClearAverages();
    bool WriteHVCommand(const char *, ...);
    void PrintConfig(int);
};

#endif
