#ifndef FACT_HeadersFSC
#define FACT_HeadersFSC

#define RESISTANCE_CHANNELS 64
#define RESISTANCE_REGS 8
#define VOLTAGE_CHANNELS 84
#define VOLTAGE_REGS 11


namespace FSC
{
    namespace State
    {
        enum states_t
        {
            kDisconnected = 1,
            kConnected    = 2,
        };
    }
    
    

    typedef struct {
        uint8_t ad7719_readings_since_last_muxing;
        uint8_t ad7719_current_channel;
        uint32_t ad7719_current_reading;
        uint8_t ad7719_enables[RESISTANCE_REGS];
        uint8_t ad7719_channels_ready[RESISTANCE_REGS];
        uint32_t ad7719_values[RESISTANCE_CHANNELS];
        uint16_t ad7719_values_checksum;

        uint8_t adc_readings_since_last_muxing;
        uint8_t adc_current_channel;
        uint16_t adc_current_reading;
        uint8_t adc_enables[VOLTAGE_REGS];
        uint8_t adc_channels_ready[VOLTAGE_REGS];
        uint16_t adc_values[VOLTAGE_CHANNELS];
        uint16_t adc_values_checksum;

        uint8_t ad7719_measured_all;    // treat it as a bool
        uint8_t adc_measured_all;       // treat it as a bool

        uint8_t app_reset_source;
        uint32_t time_sec;
        uint16_t time_ms;
    } __attribute__((__packed__)) BinaryOutput_t;
}

#endif

