#include "muxer_fsc.h"
// Sets voltage Muxer to current channel
// this is a Muxing, and therefor the adc might need some time to settle.
// Since there are:
//	- 40 voltage monitor channels
// 	- 40 current monitor channels
// 	- 4 humidity monitor channels
// the muxer is set as follows.
// channel 00..39 --> looking at the voltage channels
// channel 40..79 --> looking at the current channels
// channel 80..83 --> looking at the humidities
void Set_V_Muxer (U08 channel) {
    U08 SB = 0;
    // voltages
    if (channel < 40) {
        if (channel < 36)
            SB = channel*2;
        else
            SB = (channel+1)*2;
    }
    // currents
    else if (channel < 80) {
        channel -= 40;
        if (channel < 36)
            SB = channel*2+1;
        else
            SB = (channel+1)*2+1;
    }
    // humidities
    else if (channel < 84) {
        channel -= 80;
        switch (channel) {
            case 0:
                SB = 0x48; //0100.1000
                break;
            case 1:
                SB = 0x49; //0100.1001
                break;
            case 2:
                SB = 0x52; //0101.0010
                break;
            case 3:
                SB = 0x53; //0101.0011
                break;
        } // end of switch-case
    } // end of if (channel < some_number)

    PORTC = (PORTC & 0x80) | (0x7F & SB); // Here the muxer is switched.
}

void Set_T_Muxer(U08 channel) {
    U08 SA = 0x00;
    switch (channel/16) {
        case 0:
            SA |= 1<<4; // 0001.0000
            break;
        case 1:
            break;		// 0000.0000
        case 2:
            SA |= (1<<4)|(1<<5); // 0011.0000
            break;
        case 3:
            SA |= 1<<5;  // 0010.0000
            break;
    }
    SA =  SA | (channel%16);
    PORTA = (PORTA & 0xC0) | (0x3F & SA); // Here the muxer is switched.
}


