#ifndef MARS_MSelFinal
#define MARS_MSelFinal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelFinal                                                               //
//                                                                         //
// Task to evaluate final cuts                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MHadronness;

class MSelFinal : public MTask
{
private:
    const MGeomCam    *fCam;      // Camera Geometry 
    const MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    const MMcEvt      *fMcEvt;       
    const MHillas     *fHil;       
    const MHillasSrc  *fHilsrc;       
    const MHadronness *fHadronness;       

          Double_t     fMm2Deg;   // conversion mm to degrees in camera
          Int_t        fErrors[2];

public:
    MSelFinal(const MHillas *fHil, const MHillasSrc *fHilsrc,
              const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();


    ClassDef(MSelFinal, 0)   // Task to evaluate final cuts
};

#endif











