import sys
import os

if len(sys.argv) > 1:
    path_to_libz_so = sys.argv[1]
else:
    path_to_libz_so = None

def readlinkabs(l):
    """
    Return an absolute path for the destination 
    of a symlink
    """
    assert (os.path.islink(l))
    p = os.readlink(l)
    if os.path.isabs(p):
        return p
    return os.path.join(os.path.dirname(l), p)

def find_libz():
    print "Searching for libz.so ..."
    search_pathes = ['/usr']
    found_pathes = [] 

    for sp in search_pathes:
        find_result = os.popen("find %s | grep libz.so"%sp).readlines()
        for line in find_result:
            found_pathes.append(line.split())
    if len(found_pathes) == 0:
        print "Error: libz.so not found!"
        return None
    elif len(found_pathes) > 1:
        print "Error: Multiple Possibilities found, please choose one from:"
        print found_pathes
        return None
    else:
        print "Found libz.so in", found_pathes[0]
        return found_pathes[0]
    

print "Welcome to the pyfact installer"
print "-------------------------------"

print "Trying to import ROOT"
try:
    import ROOT
    root_available = True
except ImportError:
    root_available = False

if not root_available:
    print "Was not able to import ROOT ... aborting"
    sys.exit(1)

print "Found ROOT Version", ROOT.gROOT.GetVersion(), "in", ROOT.__file__
print 
print "Checking if libz is already loaded into ROOT." 
print "(Please ignore ROOT ouput):"
libz_loaded_check = ROOT.gSystem.Load("libz")
print " End of ROOT output"
if libz_loaded_check != 1:
  print "libz is not loaded into ROOT"
  if not path_to_libz_so:
    print "Searching for libz.so ..."
    path_to_libz_so = find_libz()
    if not path_to_libz_so:
      print "Was not able to find unique libz.so path ... aborting"
      sys.exit(1)
  ROOT.gSystem.Load(path_to_libz_so)

print "Compiling C++ headers with ACliC"
ROOT.gROOT.ProcessLine(".L extern_Mars_mcore/izstream.h+O");
ROOT.gROOT.ProcessLine(".L fits.h+O");
ROOT.gROOT.ProcessLine(".L extern_Mars_mcore/zfits.h+O");
ROOT.gROOT.ProcessLine(".L extern_Mars_mcore/factfits.h+O");
ROOT.gROOT.ProcessLine(".L calfactfits.h+O");

print
print "done."
sys.exit(0)
