#ifndef MARS_MMcTriggerLvl2
#define MARS_MMcTriggerLvl2

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MMcTrig;
class MGeomCamMagic;
class MCamDisplay;

class MMcTriggerLvl2 : public MParContainer
{

 private:

  Int_t fPixels[36][19];  // Array with the triggered pixels. 1st idx:pixels in trigger cell; 2nd idx:trigger cell number  

  static const Int_t pixels_in_cell[36][19];
  static const Int_t pixels_in_lut[3][12];

  Int_t fLutPseudoSize;  // number of compact pixels in one lut
  Int_t fPseudoSize;  // Multiplicity of the cluster identified by the L2T 
  Int_t fSizeBiggerCell; // Number of fired pixel in bigger cell

  MMcTrig *fMcTrig;
  MGeomCamMagic *fGeomcam;  
  MCamDisplay *fCam;

  Int_t CalcBiggerFiredCell();
  Int_t CalcBiggerLutPseudoSize(int neighpix);
  Int_t CalcPseudoSize(int neighpix);
   
 public: 

  MMcTriggerLvl2(const char* name = NULL, const char* title = NULL);
  
  
  void DrawCell(Int_t cell);  
  void DrawLv1();

  virtual void Calc(int neighpix=2);

  virtual void Print(Option_t *opt="") const;

  void SetLv1(MMcTrig *trig = NULL); 
  void SetPixelFired(Int_t pixel, Int_t fired=1);
 
  Int_t GetPseudoSize()     {return fPseudoSize;}
  Int_t GetLutPseudoSize()  {return fLutPseudoSize;}
  Int_t GetSizeBiggerCell() {return fSizeBiggerCell;}

  Int_t GetCellNumberFired(int cell);
  Int_t GetLutCompactPixel(int cell, int lut, int neighpix=2);

  ClassDef(MMcTriggerLvl2,0) // Container for 2nd Level Trigger selection parameters
};

#endif


