/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Antonio Stamerra  1/2003 <mailto:antono.stamerra@pi.infn.it>
!   Author(s): Marcos Lopez 1/2003 <mailto:marcos@gae.ucm.es>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTriggerLvl2Calc                                                        //
//   This is a task to calculate the 2nd level trigger selection           //
//   parameters                                                            //
//                                                                         //
//  Input containers:                                                      //
//    MMcTriggerLvl2                                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MMcTriggerLvl2Calc.h"
#include "MMcTriggerLvl2.h"


#include "MParList.h"
#include "MLog.h"
#include "MLogManip.h"

#include "MMcEvt.hxx"
#include "MMcTrig.hxx"
#include "MMcRunHeader.hxx"

#include <TH1.h>

ClassImp(MMcTriggerLvl2Calc);

// --------------------------------------------------------------------------
//                                                                         
//  Default constructor
// 
//
MMcTriggerLvl2Calc::MMcTriggerLvl2Calc(const char *name, const char *title)
{
  fName  = name  ? name  : "MMcTriggerLvl2Calc";
  fTitle = title ? title : "Task to Fill the MMcTriggerLvl2 object";
  
  //  AddToBranchList("MMcEvt.fEnergy");
  //AddToBranchList(Form("%s.fNumFirstLevel", "MMcTrig"));
  //AddToBranchList(Form("%s.fPixelsFirst[73][4]", "MMcTrig"));


  //  h1 = new TH1F("h1","h1",30,0,30);
} 


// --------------------------------------------------------------------------
//                                                                         
//  PreProcess
//
//
Bool_t MMcTriggerLvl2Calc::PreProcess (MParList *pList)
{
    // connect the raw data with this task

    fMcEvt = (MMcEvt*)pList->FindObject("MMcEvt");
    if (!fMcEvt)
    {
        *fLog << err << dbginf << "MMcEvt not found... exit." << endl;
        return kFALSE;
    }

    fMcTrig = (MMcTrig*)pList->FindObject("MMcTrig");
    if (!fMcTrig)
    {
        *fLog << err << dbginf << "MMcTrig not found... exit." << endl;
        return kFALSE;
    }

    fMMcTriggerLvl2 = (MMcTriggerLvl2*)pList->FindObject("MMcTriggerLvl2");
    if (!fMMcTriggerLvl2)
    {
        *fLog << err << dbginf << "MMcTriggerLvl2 not found... exit." << endl;
        return kFALSE;
    }

    return kTRUE;
}


// --------------------------------------------------------------------------
//                                                                         
//  Process 
// 
//
Bool_t MMcTriggerLvl2Calc::Process()
{
  //const Float_t energy = fMcEvt->GetEnergy();

  fMMcTriggerLvl2->SetLv1(fMcTrig);
  fMMcTriggerLvl2->Calc();

  //fMMcTriggerLvl2->DrawLv1();
  //fMMcTriggerLvl2->DrawCell(fMMcTriggerLvl2->GetBiggerFiredCell() );
  //fMMcTriggerLvl2->Print();

  //    h1->Fill( fMMcTriggerLvl2->GetCellNumberFired(fMMcTriggerLvl2->GetBiggerFiredCell()) );


  return kTRUE;
}


// --------------------------------------------------------------------------
//                                                                         
//  PostProcess : Display the histogram 
//           !to be fixed: create an histogram class!
//
Bool_t MMcTriggerLvl2Calc::PostProcess()
{ 
  
  //   *fLog << inf << "Filling..." << endl;
 
  //    h1->Draw();
      
    return kTRUE;
}

