#ifndef MARS_MSelFinal
#define MARS_MSelFinal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelFinal                                                               //
//                                                                         //
// Task to evaluate final cuts                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MHadronness;

class MSelFinal : public MTask
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilsrc;       
    MHadronness *fHadronness;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fErrors[2];

public:
    MSelFinal(MHillas *fHil, MHillasSrc *fHilsrc,
              const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();


    ClassDef(MSelFinal, 0)   // Task to evaluate final cuts
};

#endif











