#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get dates
if [ "$certaindate" != "" ]
then
   checkstring=`echo $certaindate | grep -E -o '^20[0-9][0-9]\/[01][0-9]\/[0-3][0-9]$'`
   if [ "$checkstring" = "" ]
   then
      echo "Please give the variable certaindate in the correct format (YYYY/MM/DD)"
      finish
   fi
   getdates $certaindate
else
   if [ "$1" = "" ]
   then 
      # get all night
      #getdates "all"
      # get last 6 nights if hour between 7 and 19h, else only current night
      getdates 6 7 19
   else
      getdates $1
   fi
fi



for date in ${dates[@]}
do 
   printprocesslog "INFO processing "$date
   #echo "INFO processing "$date
   night=`echo $date | sed -e 's/\///g'`
   
   numganymeds=0
   
   # getting all image files for this night
   printprocesslog "INFO get file list for night "$date
   files=( `find $anapath/star/$date -type f -name '*_I.root' 2>/dev/null | sort` )
   if [ ${#files[@]} -eq 0 ]
   then
      printprocesslog "INFO no image files available for night "$date
      continue
   fi
   # write data set file
   #dspath=$anapath/$source/datasets`printf %03d $min`min/$date
   #dspath=$anapath/$source/datasets_run/$date
   dspath=$anapath/datasets_run/$date
   makedir $dspath

   for (( i=1 ; i<=${#files[@]} ; i++ ))
   do
      night=`basename ${files[$i-1]} | cut -d_ -f1`
      run=`basename ${files[$i-1]} | cut -d_ -f2`
      printprocesslog "DEBUG night: "$night" run: "$run
      dsfile=$dspath"/dataset"$night"_"$run".txt"
      #echo $dsfile
      printprocesslog "INFO writing dataset file "$dsfile
      # write dataset only if merpp-log is available to make sure that star-file is complete
      if echo $resulttable1 | grep ISDC >/dev/null 2>&1
      then 
         query="SELECT LPAD(fSequenceID, 3, 0) FROM RunInfo WHERE fNight="$night" AND fRunID="$run
         seq=`sendquery`
         merpplog=`dirname ${files[$i-1]}`"/"$night"_"$seq"-merpp.log"
      else 
         merpplog=`echo ${files[$i-1]} | sed -e 's/_I.root/-merpp.log/'`
      fi
      stillrunning=`find $merpplog -mmin -1 2>/dev/null`
      if [ -e $merpplog ] && [ "$stillrunning" == "" ]
      then
         echo `dirname ${files[$i-1]}`" "`basename ${files[$i-1]}` > $dsfile
      else
         printprocesslog "INFO merpp still running - wait with file "${files[$i-1]}
         continue
      fi
      # process only if ganymedlogfiles is not yet there
      logfile=`echo $dsfile | sed -e 's/datasets/ganymed/' -e 's/dataset//' -e 's/[.]txt/-ganymed[.]log/'`
      if ! ls $logfile >/dev/null 2>&1
      then
         # fixme: why is this double?
         night=`basename ${files[$i-1]} | cut -d_ -f1`
         runid=`basename ${files[$i-1]} | cut -d_ -f2 | cut -d. -f1`
         drivefile=$auxdata"/"$date"/"`basename ${files[$i-1]} | cut -d_ -f1`".DRIVE_CONTROL_SOURCE_POSITION.fits"
         rawfilepath=$rawdata"/"$date"/"
         rawfilename=`basename ${files[$i-1]} | sed -e 's/_I.root/.fits/'`
         rawfile=`find $rawfilepath -name $rawfilename* 2>/dev/null`
         if ! [ "$rawfile" == "" ]
         then 
            printprocesslog "INFO processing "$rawfile
            tstopi=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep TSTOPI | grep -E -o '[0-9]+'`
            tstopf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep TSTOPF | grep -E -o '[.][0-9]+'`
            tstop=${tstopi}${tstopf}
         fi
         #echo "tstop: "$tstop
         if [ ls $drivefile >/dev/null 2>&1 ] && ! [ "$tstop" == "" ]
         then
            printprocesslog "INFO getting coordinates from "$drivefile
            coordinates=( `${factpath}/fitsdump ${drivefile} -c Ra_src Dec_src -r --filter='Time<'${tstop}  2>/dev/null | tail -1 2>&1` )
            if [ "${coordinates[0]}" == "" ] || [ "${coordinates[1]}" == "" ]
            then
               printprocesslog "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
               #echo "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
               continue
            fi
            if [ "${coordinates[0]}" == "0" ] || [ "${coordinates[1]}" == "0" ]
            then
               printprocesslog "WARN coordinates "${coordinates[@]}
               #echo "WARN coordinates "${coordinates[@]}
               continue
            fi
         else
            printprocesslog "INFO getting coordinates from DB."
            query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$night" AND fRunID="$runid
            sourcekey=`sendquery`
            if [ "$sourcekey" == "" ]
            then
               printprocesslog "WARN sourcekey empty - coordinates"${coordinates[@]}
               #echo "WARN sourcekey empty - coordinates"${coordinates[@]}" for "$rawfile
               continue
            fi
            query="SELECT Round(fRightAscension,6), Round(fDeclination,6) from Source WHERE fSourceKey="$sourcekey
            coordinates=( `sendquery` )
            if [ "${coordinates[0]}" == "" ] || [ "${coordinates[1]}" == "" ]
            then
               printprocesslog "WARN couldn't get coordinates ("${coordinates[@]}") from DB."
               #echo "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
               continue
            fi
            if [ "${coordinates[0]}" == "0" ] || [ "${coordinates[1]}" == "0" ]
            then
               printprocesslog "WARN coordinates "${coordinates[@]}
               #echo "WARN coordinates "${coordinates[@]}
               continue
            fi
         fi

         printprocesslog "DEBUG "$logfile" "${files[$i-1]}" -"${coordinates[0]}"-"${coordinates[1]}
         printprocesslog "DEBUG `dirname $0`/RunGanymed.sh $dsfile "${coordinates[0]}" "${coordinates[1]}
         if [ "$qlasge" = "yes" ]
         then
            printprocesslog "$sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v dsfile=$dsfile -v ra=${coordinates[0]} -v dec=${coordinates[1]} -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh"
            $sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v dsfile=$dsfile -v ra=${coordinates[0]} -v dec=${coordinates[1]} -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh
         else
            `dirname $0`/RunGanymed.sh $dsfile ${coordinates[0]} ${coordinates[1]}
            #echo "ganymed for "$dsfile" "${coordinates[0]}" "${coordinates[1]}
         fi
         numganymeds=`echo " $numganymeds + 1 " | bc -l`
      fi
   done
   printprocesslog "INFO found "$numganymeds" ganymeds."
done

finish

